/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.dimension;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.geotools.referencing.CRS;
import org.locationtech.geowave.core.index.ByteArrayUtils;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.geowave.core.index.persist.Persistable;
import org.locationtech.geowave.core.index.persist.PersistenceUtils;
import org.locationtech.geowave.core.store.dimension.NumericDimensionField;
import org.locationtech.geowave.core.store.index.BasicIndexModel;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomCrsIndexModel
extends BasicIndexModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomCrsIndexModel.class);
    private String crsCode;
    private CoordinateReferenceSystem crs;

    public CustomCrsIndexModel() {
    }

    public CustomCrsIndexModel(NumericDimensionField<?>[] dimensions, String crsCode) {
        this.init(dimensions);
        this.crsCode = crsCode;
    }

    public CoordinateReferenceSystem getCrs() {
        if (this.crs == null) {
            try {
                this.crs = CRS.decode((String)this.crsCode, (boolean)true);
            }
            catch (FactoryException e) {
                LOGGER.warn("Unable to decode indexed crs", (Throwable)e);
            }
        }
        return this.crs;
    }

    public String getCrsCode() {
        return this.crsCode;
    }

    public void init(NumericDimensionField<?>[] dimensions) {
        super.init(dimensions);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        String className = ((Object)((Object)this)).getClass().getName();
        result = 31 * result + (className == null ? 0 : className.hashCode());
        result = 31 * result + Arrays.hashCode(this.dimensions);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CustomCrsIndexModel other = (CustomCrsIndexModel)((Object)obj);
        return Arrays.equals(this.dimensions, other.dimensions);
    }

    public byte[] toBinary() {
        byte[] crsCodeBinary = StringUtils.stringToBinary((String)this.crsCode);
        int byteBufferLength = VarintUtils.unsignedIntByteLength((int)this.dimensions.length) + VarintUtils.unsignedIntByteLength((int)crsCodeBinary.length) + crsCodeBinary.length;
        ArrayList<byte[]> dimensionBinaries = new ArrayList<byte[]>(this.dimensions.length);
        for (NumericDimensionField dimension : this.dimensions) {
            byte[] dimensionBinary = PersistenceUtils.toBinary((Persistable)dimension);
            byteBufferLength += VarintUtils.unsignedIntByteLength((int)dimensionBinary.length) + dimensionBinary.length;
            dimensionBinaries.add(dimensionBinary);
        }
        ByteBuffer buf = ByteBuffer.allocate(byteBufferLength);
        VarintUtils.writeUnsignedInt((int)this.dimensions.length, (ByteBuffer)buf);
        VarintUtils.writeUnsignedInt((int)crsCodeBinary.length, (ByteBuffer)buf);
        for (byte[] dimensionBinary : dimensionBinaries) {
            VarintUtils.writeUnsignedInt((int)dimensionBinary.length, (ByteBuffer)buf);
            buf.put(dimensionBinary);
        }
        buf.put(crsCodeBinary);
        return buf.array();
    }

    public void fromBinary(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        int numDimensions = VarintUtils.readUnsignedInt((ByteBuffer)buf);
        int crsCodeLength = VarintUtils.readUnsignedInt((ByteBuffer)buf);
        this.dimensions = new NumericDimensionField[numDimensions];
        for (int i = 0; i < numDimensions; ++i) {
            byte[] dim = ByteArrayUtils.safeRead((ByteBuffer)buf, (int)VarintUtils.readUnsignedInt((ByteBuffer)buf));
            this.dimensions[i] = (NumericDimensionField)PersistenceUtils.fromBinary((byte[])dim);
        }
        byte[] codeBytes = ByteArrayUtils.safeRead((ByteBuffer)buf, (int)crsCodeLength);
        this.crsCode = StringUtils.stringFromBinary((byte[])codeBytes);
        this.init(this.dimensions);
    }
}

