/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.geotime.util.TWKBUtils;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;

public class TWKBReader {
    public Geometry read(byte[] bytes) throws ParseException {
        return this.read(ByteBuffer.wrap(bytes));
    }

    public Geometry read(ByteBuffer input) throws ParseException {
        try {
            PrecisionReader precision;
            byte typeAndPrecision = input.get();
            byte type = (byte)(typeAndPrecision & 0xF);
            int basePrecision = TWKBUtils.zigZagDecode((typeAndPrecision & 0xF0) >> 4);
            byte metadata = input.get();
            if ((metadata & 8) != 0) {
                byte extendedDimensions = input.get();
                precision = new ExtendedPrecisionReader(basePrecision, extendedDimensions);
            } else {
                precision = new PrecisionReader(basePrecision);
            }
            switch (type) {
                case 1: {
                    return this.readPoint(precision, metadata, input);
                }
                case 2: {
                    return this.readLineString(precision, metadata, input);
                }
                case 3: {
                    return this.readPolygon(precision, metadata, input);
                }
                case 4: {
                    return this.readMultiPoint(precision, metadata, input);
                }
                case 5: {
                    return this.readMultiLineString(precision, metadata, input);
                }
                case 6: {
                    return this.readMultiPolygon(precision, metadata, input);
                }
                case 7: {
                    return this.readGeometryCollection(input, metadata);
                }
            }
            return null;
        }
        catch (IOException e) {
            throw new ParseException("Error reading TWKB geometry.", (Throwable)e);
        }
    }

    private Point readPoint(PrecisionReader precision, byte metadata, ByteBuffer input) throws IOException {
        if ((metadata & 0x10) != 0) {
            return GeometryUtils.GEOMETRY_FACTORY.createPoint();
        }
        Coordinate coordinate = precision.readPoint(input);
        return GeometryUtils.GEOMETRY_FACTORY.createPoint(coordinate);
    }

    private LineString readLineString(PrecisionReader precision, byte metadata, ByteBuffer input) throws IOException {
        if ((metadata & 0x10) != 0) {
            return GeometryUtils.GEOMETRY_FACTORY.createLineString();
        }
        Coordinate[] coordinates = precision.readPointArray(input);
        return GeometryUtils.GEOMETRY_FACTORY.createLineString(coordinates);
    }

    private Polygon readPolygon(PrecisionReader precision, byte metadata, ByteBuffer input) throws IOException {
        if ((metadata & 0x10) != 0) {
            return GeometryUtils.GEOMETRY_FACTORY.createPolygon();
        }
        int numRings = VarintUtils.readUnsignedInt((ByteBuffer)input);
        LinearRing exteriorRing = GeometryUtils.GEOMETRY_FACTORY.createLinearRing(precision.readPointArray(input));
        LinearRing[] interiorRings = new LinearRing[numRings - 1];
        for (int i = 0; i < numRings - 1; ++i) {
            interiorRings[i] = GeometryUtils.GEOMETRY_FACTORY.createLinearRing(precision.readPointArray(input));
        }
        return GeometryUtils.GEOMETRY_FACTORY.createPolygon(exteriorRing, interiorRings);
    }

    private MultiPoint readMultiPoint(PrecisionReader precision, byte metadata, ByteBuffer input) throws IOException {
        if ((metadata & 0x10) != 0) {
            return GeometryUtils.GEOMETRY_FACTORY.createMultiPoint();
        }
        Coordinate[] points = precision.readPointArray(input);
        return GeometryUtils.GEOMETRY_FACTORY.createMultiPointFromCoords(points);
    }

    private MultiLineString readMultiLineString(PrecisionReader precision, byte metadata, ByteBuffer input) throws IOException {
        if ((metadata & 0x10) != 0) {
            return GeometryUtils.GEOMETRY_FACTORY.createMultiLineString();
        }
        int numLines = VarintUtils.readUnsignedInt((ByteBuffer)input);
        LineString[] lines = new LineString[numLines];
        for (int i = 0; i < numLines; ++i) {
            lines[i] = GeometryUtils.GEOMETRY_FACTORY.createLineString(precision.readPointArray(input));
        }
        return GeometryUtils.GEOMETRY_FACTORY.createMultiLineString(lines);
    }

    private MultiPolygon readMultiPolygon(PrecisionReader precision, byte metadata, ByteBuffer input) throws IOException {
        if ((metadata & 0x10) != 0) {
            return GeometryUtils.GEOMETRY_FACTORY.createMultiPolygon();
        }
        int numPolygons = VarintUtils.readUnsignedInt((ByteBuffer)input);
        Polygon[] polygons = new Polygon[numPolygons];
        for (int i = 0; i < numPolygons; ++i) {
            int numRings = VarintUtils.readUnsignedInt((ByteBuffer)input);
            if (numRings == 0) {
                polygons[i] = GeometryUtils.GEOMETRY_FACTORY.createPolygon();
                continue;
            }
            LinearRing exteriorRing = GeometryUtils.GEOMETRY_FACTORY.createLinearRing(precision.readPointArray(input));
            LinearRing[] interiorRings = new LinearRing[numRings - 1];
            for (int j = 0; j < numRings - 1; ++j) {
                interiorRings[j] = GeometryUtils.GEOMETRY_FACTORY.createLinearRing(precision.readPointArray(input));
            }
            polygons[i] = GeometryUtils.GEOMETRY_FACTORY.createPolygon(exteriorRing, interiorRings);
        }
        return GeometryUtils.GEOMETRY_FACTORY.createMultiPolygon(polygons);
    }

    private GeometryCollection readGeometryCollection(ByteBuffer input, byte metadata) throws ParseException {
        if ((metadata & 0x10) != 0) {
            return GeometryUtils.GEOMETRY_FACTORY.createGeometryCollection();
        }
        int numGeometries = VarintUtils.readUnsignedInt((ByteBuffer)input);
        Geometry[] geometries = new Geometry[numGeometries];
        for (int i = 0; i < numGeometries; ++i) {
            geometries[i] = this.read(input);
        }
        return GeometryUtils.GEOMETRY_FACTORY.createGeometryCollection(geometries);
    }

    private static class ExtendedPrecisionReader
    extends PrecisionReader {
        private boolean hasZ = false;
        private double zPrecisionMultiplier = 0.0;
        private boolean hasM = false;
        private double mPrecisionMultiplier = 0.0;

        public ExtendedPrecisionReader(int precision, byte extendedDimensions) {
            super(precision);
            if ((extendedDimensions & 1) != 0) {
                this.hasZ = true;
                this.zPrecisionMultiplier = Math.pow(10.0, TWKBUtils.zigZagDecode(extendedDimensions >> 2 & 7));
            }
            if ((extendedDimensions & 2) != 0) {
                this.hasM = true;
                this.mPrecisionMultiplier = Math.pow(10.0, TWKBUtils.zigZagDecode(extendedDimensions >> 5 & 7));
            }
        }

        @Override
        public Coordinate readPoint(ByteBuffer input) throws IOException {
            Coordinate coordinate = super.readPoint(input);
            if (this.hasZ) {
                coordinate.setZ((double)VarintUtils.readSignedLong((ByteBuffer)input) / this.zPrecisionMultiplier);
            }
            if (this.hasM) {
                coordinate.setM((double)VarintUtils.readSignedLong((ByteBuffer)input) / this.mPrecisionMultiplier);
            }
            return coordinate;
        }

        @Override
        public Coordinate[] readPointArray(ByteBuffer input) throws IOException {
            int numCoordinates = VarintUtils.readUnsignedInt((ByteBuffer)input);
            Coordinate[] coordinates = new Coordinate[numCoordinates];
            long lastX = 0L;
            long lastY = 0L;
            long lastZ = 0L;
            long lastM = 0L;
            for (int i = 0; i < numCoordinates; ++i) {
                lastX = VarintUtils.readSignedLong((ByteBuffer)input) + lastX;
                lastY = VarintUtils.readSignedLong((ByteBuffer)input) + lastY;
                coordinates[i] = new Coordinate((double)lastX / this.precisionMultiplier, (double)lastY / this.precisionMultiplier);
                if (this.hasZ) {
                    lastZ = VarintUtils.readSignedLong((ByteBuffer)input) + lastZ;
                    coordinates[i].setZ((double)lastZ / this.zPrecisionMultiplier);
                }
                if (!this.hasM) continue;
                lastM = VarintUtils.readSignedLong((ByteBuffer)input) + lastM;
                coordinates[i].setM((double)lastM / this.mPrecisionMultiplier);
            }
            return coordinates;
        }
    }

    private static class PrecisionReader {
        protected double precisionMultiplier;

        public PrecisionReader(int precision) {
            this.precisionMultiplier = Math.pow(10.0, precision);
        }

        public Coordinate readPoint(ByteBuffer input) throws IOException {
            return new Coordinate((double)VarintUtils.readSignedLong((ByteBuffer)input) / this.precisionMultiplier, (double)VarintUtils.readSignedLong((ByteBuffer)input) / this.precisionMultiplier);
        }

        public Coordinate[] readPointArray(ByteBuffer input) throws IOException {
            int numCoordinates = VarintUtils.readUnsignedInt((ByteBuffer)input);
            Coordinate[] coordinates = new Coordinate[numCoordinates];
            long lastX = 0L;
            long lastY = 0L;
            for (int i = 0; i < numCoordinates; ++i) {
                lastX = VarintUtils.readSignedLong((ByteBuffer)input) + lastX;
                lastY = VarintUtils.readSignedLong((ByteBuffer)input) + lastY;
                coordinates[i] = new Coordinate((double)lastX / this.precisionMultiplier, (double)lastY / this.precisionMultiplier);
            }
            return coordinates;
        }
    }
}

