/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.util;

import org.locationtech.geowave.core.geotime.index.dimension.LatitudeDefinition;
import org.locationtech.geowave.core.geotime.index.dimension.LongitudeDefinition;
import org.locationtech.geowave.core.geotime.store.dimension.CustomCRSBoundedSpatialDimension;
import org.locationtech.geowave.core.geotime.store.dimension.CustomCRSBoundedSpatialDimensionX;
import org.locationtech.geowave.core.geotime.store.dimension.CustomCRSBoundedSpatialDimensionY;
import org.locationtech.geowave.core.geotime.store.dimension.CustomCRSUnboundedSpatialDimensionX;
import org.locationtech.geowave.core.geotime.store.dimension.CustomCRSUnboundedSpatialDimensionY;
import org.locationtech.geowave.core.index.dimension.NumericDimensionDefinition;
import org.locationtech.geowave.core.store.api.Index;

public class SpatialIndexUtils {
    public static boolean isLongitudeDimension(NumericDimensionDefinition dimension) {
        return dimension instanceof LongitudeDefinition || dimension instanceof CustomCRSUnboundedSpatialDimensionX || dimension instanceof CustomCRSBoundedSpatialDimensionX || dimension instanceof CustomCRSBoundedSpatialDimension && ((CustomCRSBoundedSpatialDimension)dimension).getAxis() == 0;
    }

    public static boolean isLatitudeDimension(NumericDimensionDefinition dimension) {
        return dimension instanceof LatitudeDefinition || dimension instanceof CustomCRSUnboundedSpatialDimensionY || dimension instanceof CustomCRSBoundedSpatialDimensionY || dimension instanceof CustomCRSBoundedSpatialDimension && ((CustomCRSBoundedSpatialDimension)dimension).getAxis() == 1;
    }

    public static boolean hasSpatialDimensions(Index index) {
        NumericDimensionDefinition[] indexDimensions;
        boolean hasLat = false;
        boolean hasLon = false;
        if (index.getIndexStrategy() != null && (indexDimensions = index.getIndexStrategy().getOrderedDimensionDefinitions()) != null && indexDimensions.length >= 2) {
            for (int i = 0; i < indexDimensions.length; ++i) {
                hasLat |= SpatialIndexUtils.isLatitudeDimension(indexDimensions[i]);
                hasLon |= SpatialIndexUtils.isLongitudeDimension(indexDimensions[i]);
            }
        }
        return hasLat && hasLon;
    }
}

