/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.util;

import org.apache.commons.lang3.tuple.Pair;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.filter.spatial.IntersectsImpl;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.jts.geom.Geometry;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.DWithin;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DWithinFilterVisitor
extends DuplicatingFilterVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DWithinFilterVisitor.class);

    public Object visit(DWithin filter, Object extraData) {
        IntersectsImpl newWithImpl = null;
        try {
            if (filter.getExpression1() instanceof PropertyName && filter.getExpression2() instanceof Literal) {
                Pair<Geometry, Double> geometryAndDegrees = GeometryUtils.buffer(GeometryUtils.getDefaultCRS(), (Geometry)filter.getExpression2().evaluate(extraData, Geometry.class), filter.getDistanceUnits(), filter.getDistance());
                newWithImpl = new IntersectsImpl(filter.getExpression1(), (Expression)new LiteralExpressionImpl(geometryAndDegrees.getLeft()));
            } else if (filter.getExpression2() instanceof PropertyName && filter.getExpression1() instanceof Literal) {
                Pair<Geometry, Double> geometryAndDegrees = GeometryUtils.buffer(GeometryUtils.getDefaultCRS(), (Geometry)filter.getExpression1().evaluate(extraData, Geometry.class), filter.getDistanceUnits(), filter.getDistance());
                newWithImpl = new IntersectsImpl((Expression)new LiteralExpressionImpl(geometryAndDegrees.getLeft()), filter.getExpression2());
            }
        }
        catch (TransformException e) {
            LOGGER.error("Cannot transform geoemetry to support provide distance", (Throwable)e);
            return super.visit(filter, extraData);
        }
        return newWithImpl;
    }
}

