/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.statistics;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import org.locationtech.geowave.core.geotime.store.query.TemporalRange;
import org.locationtech.geowave.core.index.Mergeable;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.geowave.core.store.adapter.statistics.AbstractDataStatistics;
import org.locationtech.geowave.core.store.adapter.statistics.StatisticsType;
import org.locationtech.geowave.core.store.api.StatisticsQueryBuilder;
import org.locationtech.geowave.core.store.entities.GeoWaveRow;
import org.threeten.extra.Interval;

public abstract class TimeRangeDataStatistics<T, B extends StatisticsQueryBuilder<Interval, B>>
extends AbstractDataStatistics<T, Interval, B> {
    private long min = Long.MAX_VALUE;
    private long max = Long.MIN_VALUE;

    protected TimeRangeDataStatistics(StatisticsType<Interval, B> statisticsType) {
        super(null, statisticsType);
    }

    public TimeRangeDataStatistics(Short internalDataAdapterId, StatisticsType<Interval, B> statisticsType) {
        super(internalDataAdapterId, statisticsType);
    }

    public TimeRangeDataStatistics(Short internalDataAdapterId, StatisticsType<Interval, B> statisticsType, String extendedId) {
        super(internalDataAdapterId, statisticsType, extendedId);
    }

    public boolean isSet() {
        return this.min != Long.MAX_VALUE || this.max != Long.MIN_VALUE;
    }

    public TemporalRange asTemporalRange() {
        return new TemporalRange(new Date(this.getMin()), new Date(this.getMax()));
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public long getRange() {
        return this.max - this.min;
    }

    public byte[] toBinary() {
        ByteBuffer buffer = super.binaryBuffer(VarintUtils.timeByteLength((long)this.min) + VarintUtils.timeByteLength((long)this.max));
        VarintUtils.writeTime((long)this.min, (ByteBuffer)buffer);
        VarintUtils.writeTime((long)this.max, (ByteBuffer)buffer);
        return buffer.array();
    }

    public void fromBinary(byte[] bytes) {
        ByteBuffer buffer = super.binaryBuffer(bytes);
        this.min = VarintUtils.readTime((ByteBuffer)buffer);
        this.max = VarintUtils.readTime((ByteBuffer)buffer);
    }

    public void entryIngested(T entry, GeoWaveRow ... kvs) {
        Interval range = this.getInterval(entry);
        if (range != null) {
            this.min = Math.min(this.min, range.getStart().toEpochMilli());
            this.max = Math.max(this.max, range.getEnd().toEpochMilli());
        }
    }

    protected abstract Interval getInterval(T var1);

    public void merge(Mergeable statistics) {
        TimeRangeDataStatistics stats;
        if (statistics != null && statistics instanceof TimeRangeDataStatistics && (stats = (TimeRangeDataStatistics)statistics).isSet()) {
            this.min = Math.min(this.min, stats.getMin());
            this.max = Math.max(this.max, stats.getMax());
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("range[adapterId=").append(super.getAdapterId());
        if (this.isSet()) {
            buffer.append(", min=").append(new Date(this.getMin()));
            buffer.append(", max=").append(new Date(this.getMax()));
        } else {
            buffer.append(", No Values");
        }
        buffer.append("]");
        return buffer.toString();
    }

    protected String resultsName() {
        return "range";
    }

    protected Object resultsValue() {
        if (this.isSet()) {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("min", this.min);
            map.put("max", this.max);
            return map;
        }
        return "undefined";
    }

    public Interval getResult() {
        if (this.isSet()) {
            return Interval.of((Instant)Instant.ofEpochMilli(this.min), (Instant)Instant.ofEpochMilli(this.max));
        }
        return null;
    }
}

