/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.statistics;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.locationtech.geowave.core.geotime.store.statistics.FieldNameStatistic;
import org.locationtech.geowave.core.geotime.store.statistics.TimeRangeDataStatistics;
import org.locationtech.geowave.core.geotime.util.TimeUtils;
import org.locationtech.geowave.core.store.adapter.statistics.FieldStatisticsQueryBuilder;
import org.locationtech.geowave.core.store.adapter.statistics.FieldStatisticsType;
import org.locationtech.geowave.core.store.adapter.statistics.InternalDataStatistics;
import org.opengis.feature.simple.SimpleFeature;
import org.threeten.extra.Interval;

public class FeatureTimeRangeStatistics
extends TimeRangeDataStatistics<SimpleFeature, FieldStatisticsQueryBuilder<Interval>>
implements FieldNameStatistic {
    public static final FieldStatisticsType<Interval> STATS_TYPE = new FieldStatisticsType("TIME_RANGE");

    public FeatureTimeRangeStatistics() {
        super(STATS_TYPE);
    }

    public FeatureTimeRangeStatistics(String fieldName) {
        this(null, fieldName);
    }

    public FeatureTimeRangeStatistics(Short adapterId, String fieldName) {
        super(adapterId, STATS_TYPE, fieldName);
    }

    @Override
    public String getFieldName() {
        return this.extendedId;
    }

    public Date getMaxTime() {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        c.setTimeInMillis(this.getMax());
        return c.getTime();
    }

    public Date getMinTime() {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        c.setTimeInMillis(this.getMin());
        return c.getTime();
    }

    @Override
    protected Interval getInterval(SimpleFeature entry) {
        return TimeUtils.getInterval(entry, this.getFieldName());
    }

    public InternalDataStatistics<SimpleFeature, Interval, FieldStatisticsQueryBuilder<Interval>> duplicate() {
        return new FeatureTimeRangeStatistics(this.adapterId, this.getFieldName());
    }
}

