/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.statistics;

import java.nio.ByteBuffer;
import java.util.HashMap;
import org.locationtech.geowave.core.geotime.index.dimension.LatitudeDefinition;
import org.locationtech.geowave.core.geotime.index.dimension.LongitudeDefinition;
import org.locationtech.geowave.core.index.Mergeable;
import org.locationtech.geowave.core.index.sfc.data.NumericData;
import org.locationtech.geowave.core.index.sfc.data.NumericRange;
import org.locationtech.geowave.core.store.adapter.statistics.AbstractDataStatistics;
import org.locationtech.geowave.core.store.adapter.statistics.StatisticsType;
import org.locationtech.geowave.core.store.api.StatisticsQueryBuilder;
import org.locationtech.geowave.core.store.entities.GeoWaveRow;
import org.locationtech.geowave.core.store.query.constraints.BasicQueryByClass;
import org.locationtech.jts.geom.Envelope;

public abstract class BoundingBoxDataStatistics<T, B extends StatisticsQueryBuilder<Envelope, B>>
extends AbstractDataStatistics<T, Envelope, B> {
    protected double minX = Double.MAX_VALUE;
    protected double minY = Double.MAX_VALUE;
    protected double maxX = -1.7976931348623157E308;
    protected double maxY = -1.7976931348623157E308;

    public BoundingBoxDataStatistics(StatisticsType<Envelope, B> statisticsType) {
        this(null, statisticsType);
    }

    public BoundingBoxDataStatistics(Short adapterId, StatisticsType<Envelope, B> statisticsType) {
        super(adapterId, statisticsType);
    }

    public BoundingBoxDataStatistics(Short adapterId, StatisticsType<Envelope, B> statisticsType, String fieldName) {
        super(adapterId, statisticsType, fieldName);
    }

    public boolean isSet() {
        return this.minX != Double.MAX_VALUE && this.minY != Double.MAX_VALUE && this.maxX != -1.7976931348623157E308 && this.maxY != -1.7976931348623157E308;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getWidth() {
        return this.maxX - this.minX;
    }

    public double getHeight() {
        return this.maxY - this.minY;
    }

    public byte[] toBinary() {
        ByteBuffer buffer = super.binaryBuffer(32);
        buffer.putDouble(this.minX);
        buffer.putDouble(this.minY);
        buffer.putDouble(this.maxX);
        buffer.putDouble(this.maxY);
        return buffer.array();
    }

    public void fromBinary(byte[] bytes) {
        ByteBuffer buffer = super.binaryBuffer(bytes);
        this.minX = buffer.getDouble();
        this.minY = buffer.getDouble();
        this.maxX = buffer.getDouble();
        this.maxY = buffer.getDouble();
    }

    public void entryIngested(T entry, GeoWaveRow ... rows) {
        Envelope env = this.getEnvelope(entry);
        if (env != null) {
            this.minX = Math.min(this.minX, env.getMinX());
            this.minY = Math.min(this.minY, env.getMinY());
            this.maxX = Math.max(this.maxX, env.getMaxX());
            this.maxY = Math.max(this.maxY, env.getMaxY());
        }
    }

    public BasicQueryByClass.ConstraintSet getConstraints() {
        NumericRange rangeLongitude = new NumericRange(this.minX, this.maxX);
        NumericRange rangeLatitude = new NumericRange(this.minY, this.maxY);
        HashMap<Class, BasicQueryByClass.ConstraintData> constraintsPerDimension = new HashMap<Class, BasicQueryByClass.ConstraintData>();
        constraintsPerDimension.put(LongitudeDefinition.class, new BasicQueryByClass.ConstraintData((NumericData)rangeLongitude, true));
        constraintsPerDimension.put(LatitudeDefinition.class, new BasicQueryByClass.ConstraintData((NumericData)rangeLatitude, true));
        return new BasicQueryByClass.ConstraintSet(constraintsPerDimension);
    }

    protected abstract Envelope getEnvelope(T var1);

    public void merge(Mergeable statistics) {
        BoundingBoxDataStatistics bboxStats;
        if (statistics != null && statistics instanceof BoundingBoxDataStatistics && (bboxStats = (BoundingBoxDataStatistics)statistics).isSet()) {
            this.minX = Math.min(this.minX, bboxStats.minX);
            this.minY = Math.min(this.minY, bboxStats.minY);
            this.maxX = Math.max(this.maxX, bboxStats.maxX);
            this.maxY = Math.max(this.maxY, bboxStats.maxY);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("bbox[internalAdapter=").append(Short.toString(super.getAdapterId()));
        if (this.isSet()) {
            buffer.append(", minX=").append(this.minX);
            buffer.append(", maxX=").append(this.maxX);
            buffer.append(", minY=").append(this.minY);
            buffer.append(", maxY=").append(this.maxY);
        } else {
            buffer.append(", No Values");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public Envelope getResult() {
        if (this.isSet()) {
            return new Envelope(this.minX, this.maxX, this.minY, this.maxY);
        }
        return new Envelope();
    }

    protected String resultsName() {
        return "boundaries";
    }

    protected Object resultsValue() {
        if (this.isSet()) {
            HashMap<String, Double> map = new HashMap<String, Double>();
            map.put("minX", this.minX);
            map.put("maxX", this.maxX);
            map.put("minY", this.minY);
            map.put("maxY", this.maxY);
            return map;
        }
        return "No Values";
    }
}

