/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.aggregate;

import org.locationtech.geowave.core.geotime.store.GeotoolsFeatureDataAdapter;
import org.locationtech.geowave.core.geotime.store.query.aggregate.FieldNameParam;
import org.locationtech.geowave.core.index.persist.Persistable;
import org.locationtech.geowave.core.store.adapter.InternalDataAdapter;
import org.locationtech.geowave.core.store.api.Aggregation;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.query.aggregate.AdapterAndIndexBasedAggregation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOptimalVectorAggregation<P extends Persistable, R, T>
implements AdapterAndIndexBasedAggregation<P, R, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseOptimalVectorAggregation.class);
    protected FieldNameParam fieldNameParam;

    public BaseOptimalVectorAggregation() {
    }

    public BaseOptimalVectorAggregation(FieldNameParam fieldNameParam) {
        this.fieldNameParam = fieldNameParam;
    }

    public P getParameters() {
        return (P)this.fieldNameParam;
    }

    public void setParameters(P parameters) {
        if (parameters instanceof FieldNameParam) {
            this.fieldNameParam = (FieldNameParam)parameters;
        }
    }

    public Aggregation<P, R, T> createAggregation(DataTypeAdapter<T> adapter, Index index) {
        GeotoolsFeatureDataAdapter gtAdapter;
        if (adapter instanceof GeotoolsFeatureDataAdapter) {
            gtAdapter = (GeotoolsFeatureDataAdapter)adapter;
        } else if (adapter instanceof InternalDataAdapter && ((InternalDataAdapter)adapter).getAdapter() instanceof GeotoolsFeatureDataAdapter) {
            gtAdapter = (GeotoolsFeatureDataAdapter)((InternalDataAdapter)adapter).getAdapter();
        } else {
            LOGGER.error("Unable to perform aggregation on non-geotools feature adapter '" + adapter.getTypeName() + "'");
            return null;
        }
        if (this.fieldNameParam == null || this.isCommonIndex(index, gtAdapter)) {
            return this.createCommonIndexAggregation();
        }
        return this.createAggregation();
    }

    protected abstract boolean isCommonIndex(Index var1, GeotoolsFeatureDataAdapter var2);

    protected abstract Aggregation<P, R, T> createCommonIndexAggregation();

    protected abstract Aggregation<P, R, T> createAggregation();
}

