/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query;

import java.nio.ByteBuffer;
import java.util.Date;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.geowave.core.index.sfc.data.NumericData;

public class TemporalRange {
    private Date startTime;
    private Date endTime;
    public static final Date START_TIME = new Date(0L);
    public static final Date END_TIME = new Date(Long.MAX_VALUE);

    public TemporalRange() {
        this.startTime = START_TIME;
        this.endTime = END_TIME;
    }

    public TemporalRange(Date startTime, Date endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public boolean isWithin(Date time) {
        return !(!this.startTime.before(time) && !this.startTime.equals(time) || !this.endTime.equals(time) && !this.endTime.after(time));
    }

    public boolean isWithin(NumericData timeRange) {
        double st = this.startTime.getTime();
        double et = this.endTime.getTime();
        double rst = timeRange.getMin();
        double ret = timeRange.getMax();
        return st < rst && et > rst || st < ret && et > ret || st < rst && et > ret;
    }

    public TemporalRange intersect(TemporalRange range) {
        Date end;
        Date start = this.startTime.after(range.getStartTime()) ? this.startTime : range.getStartTime();
        Date date = end = this.endTime.before(range.getEndTime()) ? this.endTime : range.getEndTime();
        if (start.after(end)) {
            return new TemporalRange(START_TIME, START_TIME);
        }
        return new TemporalRange(start, end);
    }

    public TemporalRange union(TemporalRange range) {
        Date end;
        Date start = this.startTime.before(range.getStartTime()) ? this.startTime : range.getStartTime();
        Date date = end = this.endTime.after(range.getEndTime()) ? this.endTime : range.getEndTime();
        if (start.after(end)) {
            return new TemporalRange(START_TIME, START_TIME);
        }
        return new TemporalRange(start, end);
    }

    public void toBinary(ByteBuffer buffer) {
        VarintUtils.writeTime((long)this.startTime.getTime(), (ByteBuffer)buffer);
        VarintUtils.writeTime((long)this.endTime.getTime(), (ByteBuffer)buffer);
    }

    public byte[] toBinary() {
        ByteBuffer buf = ByteBuffer.allocate(this.getBufferSize());
        this.toBinary(buf);
        return buf.array();
    }

    public void fromBinary(ByteBuffer buffer) {
        this.startTime = new Date(VarintUtils.readTime((ByteBuffer)buffer));
        this.endTime = new Date(VarintUtils.readTime((ByteBuffer)buffer));
    }

    public void fromBinary(byte[] data) {
        ByteBuffer buf = ByteBuffer.wrap(data);
        this.fromBinary(buf);
    }

    public String toString() {
        return "TemporalRange [startTime=" + this.startTime + ", endTime=" + this.endTime + "]";
    }

    protected final int getBufferSize() {
        return VarintUtils.timeByteLength((long)this.startTime.getTime()) + VarintUtils.timeByteLength((long)this.endTime.getTime());
    }

    public boolean isInfinity() {
        return this.startTime.getTime() == 0L && this.endTime.getTime() == END_TIME.getTime();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.endTime == null ? 0 : this.endTime.hashCode());
        result = 31 * result + (this.startTime == null ? 0 : this.startTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TemporalRange other = (TemporalRange)obj;
        if (this.endTime == null ? other.endTime != null : !this.endTime.equals(other.endTime)) {
            return false;
        }
        return !(this.startTime == null ? other.startTime != null : !this.startTime.equals(other.startTime));
    }
}

