/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.geotools.factory.CommonFactoryFinder;
import org.locationtech.geowave.core.geotime.index.api.TemporalIndexBuilder;
import org.locationtech.geowave.core.geotime.store.GeotoolsFeatureDataAdapter;
import org.locationtech.geowave.core.geotime.store.query.AbstractVectorConstraints;
import org.locationtech.geowave.core.geotime.store.query.ExplicitTemporalQuery;
import org.locationtech.geowave.core.geotime.util.IndexOptimizationUtils;
import org.locationtech.geowave.core.geotime.util.TimeUtils;
import org.locationtech.geowave.core.index.sfc.data.MultiDimensionalNumericData;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.query.constraints.QueryConstraints;
import org.opengis.filter.Filter;

public class TemporalQuery
extends AbstractVectorConstraints<ExplicitTemporalQuery> {
    public TemporalQuery() {
    }

    public TemporalQuery(ExplicitTemporalQuery delegateConstraints) {
        super(delegateConstraints);
    }

    @Override
    protected ExplicitTemporalQuery newConstraints() {
        return new ExplicitTemporalQuery();
    }

    @Override
    protected boolean isSupported(Index index, GeotoolsFeatureDataAdapter adapter) {
        return IndexOptimizationUtils.hasTime(index, adapter);
    }

    @Override
    protected Filter getFilter(GeotoolsFeatureDataAdapter adapter) {
        return TemporalQuery.getFilter(adapter, this.delegateConstraints);
    }

    protected static Filter getFilter(GeotoolsFeatureDataAdapter adapter, QueryConstraints delegateConstraints) {
        List constraints = delegateConstraints.getIndexConstraints(new TemporalIndexBuilder().createIndex());
        if (adapter.getTimeDescriptors().getTime() != null) {
            return TemporalQuery.constraintsToFilter(constraints, data -> TimeUtils.toDuringFilter((long)data.getMinValuesPerDimension()[0], (long)data.getMaxValuesPerDimension()[0], adapter.getTimeDescriptors().getTime().getLocalName()));
        }
        if (adapter.getTimeDescriptors().getStartRange() != null && adapter.getTimeDescriptors().getEndRange() != null) {
            return TemporalQuery.constraintsToFilter(constraints, data -> TimeUtils.toFilter((long)data.getMinValuesPerDimension()[0], (long)data.getMaxValuesPerDimension()[0], adapter.getTimeDescriptors().getStartRange().getLocalName(), adapter.getTimeDescriptors().getEndRange().getLocalName()));
        }
        return null;
    }

    private static Filter constraintsToFilter(List<MultiDimensionalNumericData> constraints, Function<MultiDimensionalNumericData, Filter> dataToFilter) {
        if (!constraints.isEmpty()) {
            List filters = constraints.stream().map(dataToFilter).collect(Collectors.toList());
            if (filters.size() > 1) {
                return CommonFactoryFinder.getFilterFactory2().or(filters);
            }
            return (Filter)filters.get(0);
        }
        return null;
    }
}

