/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.locationtech.geowave.core.geotime.store.query.TemporalConstraints;

public class TemporalConstraintsSet {
    final Map<String, TemporalConstraints> constraintsSet = new HashMap<String, TemporalConstraints>();
    private boolean exact = true;

    public boolean hasConstraintsForRange(String startName, String endName) {
        return this.constraintsSet.containsKey(startName + "_" + endName);
    }

    public void setExact(boolean exact) {
        this.exact = exact;
    }

    public boolean isExact() {
        return this.exact;
    }

    public TemporalConstraints getConstraintsForRange(String startName, String endName) {
        String rangeName = startName + "_" + endName;
        if (this.constraintsSet.containsKey(rangeName)) {
            return this.constraintsSet.get(rangeName);
        }
        TemporalConstraints constraints = new TemporalConstraints(rangeName);
        this.constraintsSet.put(rangeName, constraints);
        return constraints;
    }

    public TemporalConstraints getConstraintsFor(String fieldName) {
        if (this.constraintsSet.containsKey(fieldName)) {
            return this.constraintsSet.get(fieldName);
        }
        TemporalConstraints constraints = new TemporalConstraints(fieldName);
        this.constraintsSet.put(fieldName, constraints);
        return constraints;
    }

    public void removeConstraints(String ... names) {
        for (String name : names) {
            this.constraintsSet.remove(name);
        }
    }

    public void removeAllConstraintsExcept(String ... names) {
        HashMap<String, TemporalConstraints> newConstraintsSet = new HashMap<String, TemporalConstraints>();
        for (String name : names) {
            TemporalConstraints constraints = this.constraintsSet.get(name);
            if (constraints == null) continue;
            newConstraintsSet.put(name, constraints);
        }
        this.constraintsSet.clear();
        this.constraintsSet.putAll(newConstraintsSet);
    }

    public boolean hasConstraintsFor(String propertyName) {
        return propertyName != null && this.constraintsSet.containsKey(propertyName);
    }

    public Set<Map.Entry<String, TemporalConstraints>> getSet() {
        return this.constraintsSet.entrySet();
    }

    public boolean isEmpty() {
        if (this.constraintsSet.isEmpty()) {
            return true;
        }
        boolean isEmpty = true;
        for (Map.Entry<String, TemporalConstraints> entry : this.getSet()) {
            isEmpty &= entry.getValue().isEmpty();
        }
        return isEmpty;
    }
}

