/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query;

import org.geotools.factory.CommonFactoryFinder;
import org.locationtech.geowave.core.geotime.store.GeotoolsFeatureDataAdapter;
import org.locationtech.geowave.core.geotime.store.query.AbstractVectorConstraints;
import org.locationtech.geowave.core.geotime.store.query.ExplicitSpatialQuery;
import org.locationtech.geowave.core.geotime.store.query.ExplicitSpatialTemporalQuery;
import org.locationtech.geowave.core.geotime.store.query.SpatialQuery;
import org.locationtech.geowave.core.geotime.store.query.TemporalQuery;
import org.locationtech.geowave.core.geotime.util.IndexOptimizationUtils;
import org.locationtech.geowave.core.store.api.Index;
import org.opengis.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialTemporalQuery
extends AbstractVectorConstraints<ExplicitSpatialTemporalQuery> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpatialTemporalQuery.class);

    public SpatialTemporalQuery() {
    }

    public SpatialTemporalQuery(ExplicitSpatialTemporalQuery delegateConstraints) {
        super(delegateConstraints);
    }

    @Override
    protected ExplicitSpatialTemporalQuery newConstraints() {
        return new ExplicitSpatialTemporalQuery();
    }

    @Override
    protected boolean isSupported(Index index, GeotoolsFeatureDataAdapter adapter) {
        return IndexOptimizationUtils.hasTime(index, adapter) && IndexOptimizationUtils.hasAtLeastSpatial(index);
    }

    @Override
    protected Filter getFilter(GeotoolsFeatureDataAdapter adapter) {
        Filter spatialFilter = SpatialQuery.getFilter(adapter, (ExplicitSpatialQuery)this.delegateConstraints);
        if (spatialFilter == null) {
            LOGGER.warn("Spatial filter does not apply to type '" + adapter.getTypeName() + "'");
            return null;
        }
        Filter temporalFilter = TemporalQuery.getFilter(adapter, this.delegateConstraints);
        if (temporalFilter == null) {
            LOGGER.warn("Temporal filter does not apply to type '" + adapter.getTypeName() + "'");
            return null;
        }
        return CommonFactoryFinder.getFilterFactory2().and(spatialFilter, temporalFilter);
    }
}

