/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query;

import java.time.Instant;
import java.util.Date;
import org.apache.commons.lang3.ArrayUtils;
import org.locationtech.geowave.core.geotime.store.query.ExplicitSpatialQuery;
import org.locationtech.geowave.core.geotime.store.query.ExplicitSpatialTemporalQuery;
import org.locationtech.geowave.core.geotime.store.query.ExplicitTemporalQuery;
import org.locationtech.geowave.core.geotime.store.query.SpatialQuery;
import org.locationtech.geowave.core.geotime.store.query.SpatialTemporalQuery;
import org.locationtech.geowave.core.geotime.store.query.TemporalQuery;
import org.locationtech.geowave.core.geotime.store.query.api.SpatialTemporalConstraintsBuilder;
import org.locationtech.geowave.core.geotime.store.query.filter.SpatialQueryFilter;
import org.locationtech.geowave.core.store.query.constraints.EverythingQuery;
import org.locationtech.geowave.core.store.query.constraints.QueryConstraints;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.extra.Interval;

public class SpatialTemporalConstraintsBuilderImpl
implements SpatialTemporalConstraintsBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpatialTemporalConstraintsBuilderImpl.class);
    private String crsCode;
    private Geometry geometry;
    private SpatialQueryFilter.CompareOperation spatialCompareOp;
    private Interval[] timeRanges = new Interval[0];

    @Override
    public SpatialTemporalConstraintsBuilder noSpatialConstraints() {
        this.geometry = null;
        this.crsCode = null;
        this.spatialCompareOp = null;
        return this;
    }

    @Override
    public SpatialTemporalConstraintsBuilder spatialConstraints(Geometry geometry) {
        this.geometry = geometry;
        return this;
    }

    @Override
    public SpatialTemporalConstraintsBuilder spatialConstraintsCrs(String crsCode) {
        this.crsCode = crsCode;
        return this;
    }

    @Override
    public SpatialTemporalConstraintsBuilder spatialConstraintsCompareOperation(SpatialQueryFilter.CompareOperation spatialCompareOp) {
        this.spatialCompareOp = spatialCompareOp;
        return this;
    }

    @Override
    public SpatialTemporalConstraintsBuilder noTemporalConstraints() {
        this.timeRanges = new Interval[0];
        return this;
    }

    @Override
    public SpatialTemporalConstraintsBuilder addTimeRange(Date startTime, Date endTime) {
        return this.addTimeRange(Interval.of((Instant)Instant.ofEpochMilli(startTime.getTime()), (Instant)Instant.ofEpochMilli(endTime.getTime())));
    }

    @Override
    public SpatialTemporalConstraintsBuilder addTimeRange(Interval timeRange) {
        this.timeRanges = (Interval[])ArrayUtils.add((Object[])this.timeRanges, (Object)timeRange);
        return this;
    }

    @Override
    public SpatialTemporalConstraintsBuilder setTimeRanges(Interval[] timeRanges) {
        if (timeRanges == null) {
            this.timeRanges = new Interval[0];
        }
        this.timeRanges = timeRanges;
        return this;
    }

    @Override
    public QueryConstraints build() {
        if (this.crsCode != null && this.geometry == null) {
            LOGGER.warn("CRS code `" + this.crsCode + "` cannot be applied without a geometry.  Ignoring CRS.");
        }
        if (this.spatialCompareOp != null && this.geometry == null) {
            LOGGER.warn("Spatial compare operator `" + this.spatialCompareOp.name() + "` cannot be applied without a geometry.  Ignoring compare operator.");
        }
        if (this.geometry != null) {
            if (this.timeRanges.length > 0) {
                return new SpatialTemporalQuery(new ExplicitSpatialTemporalQuery(this.timeRanges, this.geometry, this.crsCode, this.spatialCompareOp));
            }
            return new SpatialQuery(new ExplicitSpatialQuery(this.geometry, this.crsCode, this.spatialCompareOp));
        }
        if (this.timeRanges.length > 0) {
            return new TemporalQuery(new ExplicitTemporalQuery(this.timeRanges));
        }
        return new EverythingQuery();
    }
}

