/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query;

import org.locationtech.geowave.core.geotime.store.GeotoolsFeatureDataAdapter;
import org.locationtech.geowave.core.geotime.store.query.AbstractVectorConstraints;
import org.locationtech.geowave.core.geotime.store.query.ExplicitSpatialQuery;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.geotime.util.IndexOptimizationUtils;
import org.locationtech.geowave.core.store.api.Index;
import org.opengis.filter.Filter;

public class SpatialQuery
extends AbstractVectorConstraints<ExplicitSpatialQuery> {
    public SpatialQuery() {
    }

    public SpatialQuery(ExplicitSpatialQuery delegateConstraints) {
        super(delegateConstraints);
    }

    @Override
    protected ExplicitSpatialQuery newConstraints() {
        return new ExplicitSpatialQuery();
    }

    @Override
    protected boolean isSupported(Index index, GeotoolsFeatureDataAdapter adapter) {
        return IndexOptimizationUtils.hasAtLeastSpatial(index);
    }

    @Override
    protected Filter getFilter(GeotoolsFeatureDataAdapter adapter) {
        return SpatialQuery.getFilter(adapter, (ExplicitSpatialQuery)this.delegateConstraints);
    }

    protected static Filter getFilter(GeotoolsFeatureDataAdapter adapter, ExplicitSpatialQuery delegateConstraints) {
        return GeometryUtils.geometryToSpatialOperator(delegateConstraints.getQueryGeometry(), adapter.getFeatureType().getGeometryDescriptor().getLocalName());
    }
}

