/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query;

import java.util.ArrayList;
import java.util.Date;
import org.locationtech.geowave.core.geotime.index.dimension.SimpleTimeDefinition;
import org.locationtech.geowave.core.geotime.index.dimension.TimeDefinition;
import org.locationtech.geowave.core.geotime.store.query.ExplicitSpatialQuery;
import org.locationtech.geowave.core.geotime.store.query.TemporalConstraints;
import org.locationtech.geowave.core.geotime.store.query.TemporalRange;
import org.locationtech.geowave.core.geotime.store.query.filter.SpatialQueryFilter;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.index.sfc.data.NumericData;
import org.locationtech.geowave.core.index.sfc.data.NumericRange;
import org.locationtech.geowave.core.store.query.constraints.BasicQueryByClass;
import org.locationtech.geowave.core.store.query.filter.BasicQueryFilter;
import org.locationtech.jts.geom.Geometry;
import org.threeten.extra.Interval;

public class ExplicitSpatialTemporalQuery
extends ExplicitSpatialQuery {
    public ExplicitSpatialTemporalQuery() {
    }

    public ExplicitSpatialTemporalQuery(Date startTime, Date endTime, Geometry queryGeometry) {
        super(ExplicitSpatialTemporalQuery.createSpatialTemporalConstraints(startTime, endTime, queryGeometry), queryGeometry);
    }

    public ExplicitSpatialTemporalQuery(Date startTime, Date endTime, Geometry queryGeometry, String crsCode) {
        super(ExplicitSpatialTemporalQuery.createSpatialTemporalConstraints(startTime, endTime, queryGeometry), queryGeometry, crsCode);
    }

    public ExplicitSpatialTemporalQuery(TemporalConstraints constraints, Geometry queryGeometry) {
        super(ExplicitSpatialTemporalQuery.createSpatialTemporalConstraints(constraints, queryGeometry), queryGeometry);
    }

    public ExplicitSpatialTemporalQuery(TemporalConstraints constraints, Geometry queryGeometry, String crsCode) {
        super(ExplicitSpatialTemporalQuery.createSpatialTemporalConstraints(constraints, queryGeometry), queryGeometry, crsCode);
    }

    public ExplicitSpatialTemporalQuery(Date startTime, Date endTime, Geometry queryGeometry, SpatialQueryFilter.CompareOperation compareOp) {
        super(ExplicitSpatialTemporalQuery.createSpatialTemporalConstraints(startTime, endTime, queryGeometry), queryGeometry, compareOp, compareOp.getBaseCompareOp());
    }

    public ExplicitSpatialTemporalQuery(Interval[] intervals, Geometry queryGeometry, String crsCode, SpatialQueryFilter.CompareOperation compareOp) {
        super(ExplicitSpatialTemporalQuery.createSpatialTemporalConstraints(intervals, queryGeometry), queryGeometry, crsCode, compareOp, BasicQueryFilter.BasicQueryCompareOperation.INTERSECTS);
    }

    public ExplicitSpatialTemporalQuery(TemporalConstraints constraints, Geometry queryGeometry, SpatialQueryFilter.CompareOperation compareOp) {
        super(ExplicitSpatialTemporalQuery.createSpatialTemporalConstraints(constraints, queryGeometry), queryGeometry, compareOp);
    }

    public static BasicQueryByClass.ConstraintSet createConstraints(TemporalRange temporalRange, boolean isDefault) {
        return new BasicQueryByClass.ConstraintSet(new BasicQueryByClass.ConstraintData((NumericData)new NumericRange((double)temporalRange.getStartTime().getTime(), (double)temporalRange.getEndTime().getTime()), isDefault), new Class[]{TimeDefinition.class, SimpleTimeDefinition.class});
    }

    public static BasicQueryByClass.ConstraintsByClass createConstraints(TemporalConstraints temporalConstraints, boolean isDefault) {
        ArrayList<BasicQueryByClass.ConstraintSet> constraints = new ArrayList<BasicQueryByClass.ConstraintSet>();
        for (TemporalRange range : temporalConstraints.getRanges()) {
            constraints.add(new BasicQueryByClass.ConstraintSet(new BasicQueryByClass.ConstraintData((NumericData)new NumericRange((double)range.getStartTime().getTime(), (double)range.getEndTime().getTime()), isDefault), new Class[]{TimeDefinition.class, SimpleTimeDefinition.class}));
        }
        return new BasicQueryByClass.ConstraintsByClass(constraints);
    }

    public static BasicQueryByClass.ConstraintsByClass createConstraints(Interval[] intervals, boolean isDefault) {
        ArrayList<BasicQueryByClass.ConstraintSet> constraints = new ArrayList<BasicQueryByClass.ConstraintSet>();
        for (Interval range : intervals) {
            constraints.add(new BasicQueryByClass.ConstraintSet(new BasicQueryByClass.ConstraintData((NumericData)new NumericRange((double)range.getStart().toEpochMilli(), (double)Math.max(range.getEnd().toEpochMilli() - 1L, range.getStart().toEpochMilli())), isDefault), new Class[]{TimeDefinition.class, SimpleTimeDefinition.class}));
        }
        return new BasicQueryByClass.ConstraintsByClass(constraints);
    }

    private static BasicQueryByClass.ConstraintsByClass createSpatialTemporalConstraints(TemporalConstraints temporalConstraints, Geometry queryGeometry) {
        BasicQueryByClass.ConstraintsByClass geoConstraints = GeometryUtils.basicConstraintsFromGeometry(queryGeometry);
        BasicQueryByClass.ConstraintsByClass timeConstraints = ExplicitSpatialTemporalQuery.createConstraints(temporalConstraints, false);
        return geoConstraints.merge(timeConstraints);
    }

    private static BasicQueryByClass.ConstraintsByClass createSpatialTemporalConstraints(Interval[] intervals, Geometry queryGeometry) {
        BasicQueryByClass.ConstraintsByClass geoConstraints = GeometryUtils.basicConstraintsFromGeometry(queryGeometry);
        BasicQueryByClass.ConstraintsByClass timeConstraints = ExplicitSpatialTemporalQuery.createConstraints(intervals, false);
        return geoConstraints.merge(timeConstraints);
    }

    private static BasicQueryByClass.ConstraintsByClass createSpatialTemporalConstraints(Date startTime, Date endTime, Geometry queryGeometry) {
        BasicQueryByClass.ConstraintsByClass geoConstraints = GeometryUtils.basicConstraintsFromGeometry(queryGeometry);
        return geoConstraints.merge(new BasicQueryByClass.ConstraintsByClass(new BasicQueryByClass.ConstraintSet(new BasicQueryByClass.ConstraintData((NumericData)new NumericRange((double)startTime.getTime(), (double)endTime.getTime()), false), new Class[]{TimeDefinition.class, SimpleTimeDefinition.class})));
    }
}

