/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query;

import java.util.List;
import org.locationtech.geowave.core.geotime.store.GeotoolsFeatureDataAdapter;
import org.locationtech.geowave.core.geotime.store.query.ExplicitCQLQuery;
import org.locationtech.geowave.core.geotime.util.IndexOptimizationUtils;
import org.locationtech.geowave.core.index.sfc.data.MultiDimensionalNumericData;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.query.constraints.AdapterAndIndexBasedQueryConstraints;
import org.locationtech.geowave.core.store.query.constraints.QueryConstraints;
import org.locationtech.geowave.core.store.query.filter.QueryFilter;
import org.opengis.filter.Filter;

public abstract class AbstractVectorConstraints<T extends QueryConstraints>
implements AdapterAndIndexBasedQueryConstraints,
QueryConstraints {
    protected T delegateConstraints;

    protected AbstractVectorConstraints() {
    }

    public AbstractVectorConstraints(T delegateConstraints) {
        this.delegateConstraints = delegateConstraints;
    }

    public byte[] toBinary() {
        return this.delegateConstraints.toBinary();
    }

    public List<QueryFilter> createFilters(Index index) {
        return this.delegateConstraints.createFilters(index);
    }

    public void fromBinary(byte[] bytes) {
        this.delegateConstraints = this.newConstraints();
        this.delegateConstraints.fromBinary(bytes);
    }

    protected abstract T newConstraints();

    public List<MultiDimensionalNumericData> getIndexConstraints(Index index) {
        return this.delegateConstraints.getIndexConstraints(index);
    }

    protected abstract boolean isSupported(Index var1, GeotoolsFeatureDataAdapter var2);

    protected abstract Filter getFilter(GeotoolsFeatureDataAdapter var1);

    public QueryConstraints createQueryConstraints(DataTypeAdapter<?> adapter, Index index) {
        GeotoolsFeatureDataAdapter gtAdapter = IndexOptimizationUtils.unwrapGeotoolsFeatureDataAdapter(adapter);
        if (gtAdapter != null && !this.isSupported(index, gtAdapter)) {
            Filter filter = this.getFilter(gtAdapter);
            if (filter == null) {
                return null;
            }
            return new ExplicitCQLQuery((QueryConstraints)this.delegateConstraints, filter, gtAdapter);
        }
        return this.delegateConstraints;
    }
}

