/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.field;

import java.nio.ByteBuffer;
import java.util.Date;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.geowave.core.store.data.field.FieldReader;
import org.locationtech.geowave.core.store.data.field.FieldSerializationProviderSpi;
import org.locationtech.geowave.core.store.data.field.FieldWriter;

public class DateSerializationProvider
implements FieldSerializationProviderSpi<Date> {
    public FieldReader<Date> getFieldReader() {
        return new DateReader();
    }

    public FieldWriter<Object, Date> getFieldWriter() {
        return new DateWriter();
    }

    protected static class DateWriter
    implements FieldWriter<Object, Date> {
        protected DateWriter() {
        }

        public byte[] writeField(Date fieldData) {
            if (fieldData == null) {
                return new byte[0];
            }
            ByteBuffer buf = ByteBuffer.allocate(VarintUtils.timeByteLength((long)fieldData.getTime()));
            VarintUtils.writeTime((long)fieldData.getTime(), (ByteBuffer)buf);
            return buf.array();
        }
    }

    protected static class DateReader
    implements FieldReader<Date> {
        protected DateReader() {
        }

        public Date readField(byte[] fieldData) {
            if (fieldData == null || fieldData.length == 0) {
                return null;
            }
            return new Date(VarintUtils.readTime((ByteBuffer)ByteBuffer.wrap(fieldData)));
        }

        public Date readField(byte[] fieldData, byte serializationVersion) {
            if (fieldData == null || fieldData.length == 0) {
                return null;
            }
            if (serializationVersion < 1) {
                return new Date(ByteBuffer.wrap(fieldData).getLong());
            }
            return this.readField(fieldData);
        }
    }
}

