/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.dimension;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.locationtech.geowave.core.geotime.store.dimension.GeometryWrapper;
import org.locationtech.geowave.core.geotime.store.dimension.GeometryWrapperReader;
import org.locationtech.geowave.core.geotime.store.dimension.GeometryWrapperWriter;
import org.locationtech.geowave.core.index.ByteArrayUtils;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.geowave.core.index.dimension.NumericDimensionDefinition;
import org.locationtech.geowave.core.index.dimension.bin.BinRange;
import org.locationtech.geowave.core.index.persist.Persistable;
import org.locationtech.geowave.core.index.persist.PersistenceUtils;
import org.locationtech.geowave.core.index.sfc.data.NumericData;
import org.locationtech.geowave.core.index.sfc.data.NumericRange;
import org.locationtech.geowave.core.store.data.field.FieldReader;
import org.locationtech.geowave.core.store.data.field.FieldWriter;
import org.locationtech.geowave.core.store.dimension.NumericDimensionField;
import org.locationtech.geowave.core.store.index.CommonIndexValue;

public abstract class SpatialField
implements NumericDimensionField<GeometryWrapper> {
    protected NumericDimensionDefinition baseDefinition;
    private final GeometryWrapperReader geometryReader;
    private final GeometryWrapperWriter geometryWriter;
    private String fieldName;
    private Integer geometryPrecision;

    protected SpatialField() {
        this(null);
    }

    protected SpatialField(@Nullable Integer geometryPrecision) {
        this.geometryReader = new GeometryWrapperReader(geometryPrecision);
        this.geometryWriter = new GeometryWrapperWriter(geometryPrecision);
        this.fieldName = "default_geom_dimension";
        this.geometryPrecision = geometryPrecision;
    }

    public SpatialField(NumericDimensionDefinition baseDefinition, @Nullable Integer geometryPrecision) {
        this(baseDefinition, geometryPrecision, "default_geom_dimension");
    }

    public NumericData getFullRange() {
        return this.baseDefinition.getFullRange();
    }

    public SpatialField(NumericDimensionDefinition baseDefinition, @Nullable Integer geometryPrecision, String fieldName) {
        this.baseDefinition = baseDefinition;
        this.fieldName = fieldName;
        this.geometryPrecision = geometryPrecision;
        this.geometryReader = new GeometryWrapperReader(geometryPrecision);
        this.geometryWriter = new GeometryWrapperWriter(geometryPrecision);
    }

    public NumericRange getDenormalizedRange(BinRange range) {
        return new NumericRange(range.getNormalizedMin(), range.getNormalizedMax());
    }

    public double getRange() {
        return this.baseDefinition.getRange();
    }

    public int getFixedBinIdSize() {
        return 0;
    }

    public NumericRange getBounds() {
        return this.baseDefinition.getBounds();
    }

    public double normalize(double value) {
        return this.baseDefinition.normalize(value);
    }

    public double denormalize(double value) {
        return this.baseDefinition.denormalize(value);
    }

    public BinRange[] getNormalizedRanges(NumericData range) {
        return this.baseDefinition.getNormalizedRanges(range);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public FieldWriter<?, GeometryWrapper> getWriter() {
        return this.geometryWriter;
    }

    public FieldReader<GeometryWrapper> getReader() {
        return this.geometryReader;
    }

    public NumericDimensionDefinition getBaseDefinition() {
        return this.baseDefinition;
    }

    public boolean isCompatibleWith(Class<? extends CommonIndexValue> clazz) {
        return GeometryWrapper.class.isAssignableFrom(clazz);
    }

    public byte[] toBinary() {
        byte[] dimensionBinary = PersistenceUtils.toBinary((Persistable)this.baseDefinition);
        byte[] fieldNameBytes = StringUtils.stringToBinary((String)this.fieldName);
        ByteBuffer buf = ByteBuffer.allocate(dimensionBinary.length + fieldNameBytes.length + VarintUtils.unsignedIntByteLength((int)fieldNameBytes.length) + 1);
        VarintUtils.writeUnsignedInt((int)fieldNameBytes.length, (ByteBuffer)buf);
        buf.put(fieldNameBytes);
        buf.put(dimensionBinary);
        if (this.geometryPrecision == null) {
            buf.put((byte)127);
        } else {
            buf.put((byte)this.geometryPrecision.intValue());
        }
        return buf.array();
    }

    public void fromBinary(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        int fieldNameLength = VarintUtils.readUnsignedInt((ByteBuffer)buf);
        byte[] fieldNameBytes = ByteArrayUtils.safeRead((ByteBuffer)buf, (int)fieldNameLength);
        this.fieldName = StringUtils.stringFromBinary((byte[])fieldNameBytes);
        byte[] dimensionBinary = new byte[buf.remaining() - 1];
        buf.get(dimensionBinary);
        this.baseDefinition = (NumericDimensionDefinition)PersistenceUtils.fromBinary((byte[])dimensionBinary);
        byte precision = buf.get();
        this.geometryPrecision = precision == 127 ? null : Integer.valueOf(precision);
        this.geometryReader.setPrecision(this.geometryPrecision);
        this.geometryWriter.setPrecision(this.geometryPrecision);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        String className = this.getClass().getName();
        result = 31 * result + (className == null ? 0 : className.hashCode());
        result = 31 * result + (this.baseDefinition == null ? 0 : this.baseDefinition.hashCode());
        result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        result = 31 * result + (this.geometryPrecision == null ? 0 : this.geometryPrecision.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpatialField other = (SpatialField)obj;
        if (this.baseDefinition == null ? other.baseDefinition != null : !this.baseDefinition.equals(other.baseDefinition)) {
            return false;
        }
        if (this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName)) {
            return false;
        }
        return !(this.geometryPrecision == null ? other.geometryPrecision != null : !this.geometryPrecision.equals(other.geometryPrecision));
    }
}

