/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.dimension;

import javax.annotation.Nullable;
import org.locationtech.geowave.core.geotime.store.dimension.GeometryWrapper;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.store.data.field.FieldWriter;

public class GeometryWrapperWriter
implements FieldWriter<Object, GeometryWrapper> {
    private Integer geometryPrecision = null;

    public GeometryWrapperWriter(@Nullable Integer geometryPrecision) {
        this.geometryPrecision = geometryPrecision;
    }

    public void setPrecision(@Nullable Integer geometryPrecision) {
        this.geometryPrecision = geometryPrecision;
    }

    public byte[] writeField(GeometryWrapper geometry) {
        return GeometryUtils.geometryToBinary(geometry.getGeometry(), this.geometryPrecision);
    }

    public byte[] getVisibility(Object rowValue, String fieldName, GeometryWrapper geometry) {
        return geometry.getVisibility();
    }
}

