/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.dimension;

import com.google.common.math.DoubleMath;
import org.locationtech.geowave.core.geotime.store.dimension.LatitudeField;
import org.locationtech.geowave.core.index.sfc.data.NumericData;
import org.locationtech.geowave.core.index.sfc.data.NumericRange;
import org.locationtech.geowave.core.store.dimension.NumericDimensionField;
import org.locationtech.geowave.core.store.index.CommonIndexValue;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class GeometryWrapper
implements CommonIndexValue {
    public static final String DEFAULT_GEOMETRY_FIELD_NAME = "default_geom_dimension";
    private byte[] visibility;
    private final Geometry geometry;
    private static final double DOUBLE_TOLERANCE = 1.0E-12;

    public GeometryWrapper(Geometry geometry) {
        this.geometry = geometry;
    }

    public GeometryWrapper(Geometry geometry, byte[] visibility) {
        this.visibility = visibility;
        this.geometry = geometry;
    }

    public void setVisibility(byte[] visibility) {
        this.visibility = visibility;
    }

    public byte[] getVisibility() {
        return this.visibility;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public boolean overlaps(NumericDimensionField[] fields, NumericData[] rangeData) {
        int longPosition;
        int latPosition = fields[0] instanceof LatitudeField ? 0 : 1;
        int n = longPosition = fields[0] instanceof LatitudeField ? 1 : 0;
        if (fields.length == 1) {
            Envelope env = this.geometry.getEnvelopeInternal();
            NumericRange r = latPosition == 0 ? new NumericRange(env.getMinY(), env.getMaxY()) : new NumericRange(env.getMinX(), env.getMaxX());
            return (rangeData[0].getMin() < r.getMax() || DoubleMath.fuzzyEquals((double)rangeData[0].getMin(), (double)r.getMax(), (double)1.0E-12)) && (rangeData[0].getMax() > r.getMin() || DoubleMath.fuzzyEquals((double)rangeData[0].getMax(), (double)r.getMin(), (double)1.0E-12));
        }
        return this.geometry.getFactory().createPolygon(new Coordinate[]{new Coordinate(rangeData[longPosition].getMin() - 1.0E-12, rangeData[latPosition].getMin() - 1.0E-12), new Coordinate(rangeData[longPosition].getMin() - 1.0E-12, rangeData[latPosition].getMax() + 1.0E-12), new Coordinate(rangeData[longPosition].getMax() + 1.0E-12, rangeData[latPosition].getMax() + 1.0E-12), new Coordinate(rangeData[longPosition].getMax() + 1.0E-12, rangeData[latPosition].getMin() - 1.0E-12), new Coordinate(rangeData[longPosition].getMin() - 1.0E-12, rangeData[latPosition].getMin() - 1.0E-12)}).intersects(this.geometry);
    }
}

