/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.index;

import com.beust.jcommander.Parameter;
import org.locationtech.geowave.core.geotime.index.TemporalDimensionalityTypeProvider;
import org.locationtech.geowave.core.geotime.index.dimension.TemporalBinningStrategy;
import org.locationtech.geowave.core.store.spi.DimensionalityTypeOptions;

public class TemporalOptions
implements DimensionalityTypeOptions {
    protected static TemporalBinningStrategy.Unit DEFAULT_PERIODICITY = TemporalBinningStrategy.Unit.YEAR;
    @Parameter(names={"--period"}, required=false, description="The periodicity of the temporal dimension.  Because time is continuous, it is binned at this interval.", converter=TemporalDimensionalityTypeProvider.UnitConverter.class)
    protected TemporalBinningStrategy.Unit periodicity = DEFAULT_PERIODICITY;
    @Parameter(names={"--noTimeRange"}, required=false, description="The time index can be more efficient if time ranges don't need to be supported.")
    protected boolean noTimeRanges = false;
    @Parameter(names={"--maxDuplicates"}, required=false, description="The max number of duplicates per dimension range.  The default is 2 per range (for example lines and polygon timestamp data would be up to 4 because its 2 dimensions, and line/poly time range data would be 8).")
    protected long maxDuplicates = -1L;

    public long getMaxDuplicates() {
        return this.maxDuplicates;
    }

    public TemporalBinningStrategy.Unit getPeriodicity() {
        return this.periodicity;
    }

    public boolean isSupportTimeRanges() {
        return !this.noTimeRanges;
    }

    public void setPeriodicity(TemporalBinningStrategy.Unit periodicity) {
        this.periodicity = periodicity;
    }

    public void setNoTimeRanges(boolean noTimeRanges) {
        this.noTimeRanges = noTimeRanges;
    }

    public void setMaxDuplicates(long maxDuplicates) {
        this.maxDuplicates = maxDuplicates;
    }
}

