/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.index;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.ParameterException;
import java.util.Locale;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.geotools.referencing.CRS;
import org.locationtech.geowave.core.geotime.index.SpatialTemporalOptions;
import org.locationtech.geowave.core.geotime.index.dimension.LatitudeDefinition;
import org.locationtech.geowave.core.geotime.index.dimension.LongitudeDefinition;
import org.locationtech.geowave.core.geotime.index.dimension.TemporalBinningStrategy;
import org.locationtech.geowave.core.geotime.index.dimension.TimeDefinition;
import org.locationtech.geowave.core.geotime.store.dimension.CustomCRSBoundedSpatialDimensionX;
import org.locationtech.geowave.core.geotime.store.dimension.CustomCRSBoundedSpatialDimensionY;
import org.locationtech.geowave.core.geotime.store.dimension.CustomCRSSpatialField;
import org.locationtech.geowave.core.geotime.store.dimension.CustomCRSUnboundedSpatialDimensionX;
import org.locationtech.geowave.core.geotime.store.dimension.CustomCRSUnboundedSpatialDimensionY;
import org.locationtech.geowave.core.geotime.store.dimension.CustomCrsIndexModel;
import org.locationtech.geowave.core.geotime.store.dimension.LatitudeField;
import org.locationtech.geowave.core.geotime.store.dimension.LongitudeField;
import org.locationtech.geowave.core.geotime.store.dimension.TimeField;
import org.locationtech.geowave.core.geotime.util.SpatialIndexUtils;
import org.locationtech.geowave.core.index.NumericIndexStrategy;
import org.locationtech.geowave.core.index.dimension.NumericDimensionDefinition;
import org.locationtech.geowave.core.index.sfc.SFCFactory;
import org.locationtech.geowave.core.index.sfc.xz.XZHierarchicalIndexFactory;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.dimension.NumericDimensionField;
import org.locationtech.geowave.core.store.index.BasicIndexModel;
import org.locationtech.geowave.core.store.index.CommonIndexModel;
import org.locationtech.geowave.core.store.index.CustomNameIndex;
import org.locationtech.geowave.core.store.spi.DimensionalityTypeProviderSpi;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialTemporalDimensionalityTypeProvider
implements DimensionalityTypeProviderSpi<SpatialTemporalOptions> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpatialTemporalDimensionalityTypeProvider.class);
    private static final String DEFAULT_SPATIAL_TEMPORAL_ID_STR = "ST_IDX";
    public static final double DEFAULT_UNBOUNDED_CRS_INTERVAL = 4.0075017E7;
    public static final NumericDimensionDefinition[] SPATIAL_TEMPORAL_DIMENSIONS = new NumericDimensionDefinition[]{new LongitudeDefinition(), new LatitudeDefinition(true), new TimeDefinition(SpatialTemporalOptions.DEFAULT_PERIODICITY)};

    public static NumericDimensionField[] getSpatialTemporalFields(@Nullable Integer geometryPrecision) {
        return new NumericDimensionField[]{new LongitudeField(geometryPrecision), new LatitudeField(geometryPrecision, true), new TimeField(SpatialTemporalOptions.DEFAULT_PERIODICITY)};
    }

    public String getDimensionalityTypeName() {
        return "spatial_temporal";
    }

    public String getDimensionalityTypeDescription() {
        return "This dimensionality type matches all indices that only require Geometry and Time.";
    }

    public SpatialTemporalOptions createOptions() {
        return new SpatialTemporalOptions();
    }

    public Index createIndex(SpatialTemporalOptions options) {
        return SpatialTemporalDimensionalityTypeProvider.createIndexFromOptions(options);
    }

    public static Index createIndexFromOptions(SpatialTemporalOptions options) {
        boolean isDefaultCRS;
        NumericDimensionDefinition[] dimensions;
        NumericDimensionField[] fields = null;
        CoordinateReferenceSystem crs = null;
        String crsCode = null;
        Integer geometryPrecision = options.getGeometryPrecision();
        if (options.crs == null || options.crs.isEmpty() || options.crs.equalsIgnoreCase("EPSG:4326")) {
            dimensions = SPATIAL_TEMPORAL_DIMENSIONS;
            fields = SpatialTemporalDimensionalityTypeProvider.getSpatialTemporalFields(geometryPrecision);
            isDefaultCRS = true;
            crsCode = "EPSG:4326";
        } else {
            crs = SpatialTemporalDimensionalityTypeProvider.decodeCRS(options.crs);
            CoordinateSystem cs = crs.getCoordinateSystem();
            isDefaultCRS = false;
            crsCode = options.crs;
            dimensions = new NumericDimensionDefinition[cs.getDimension() + 1];
            fields = new NumericDimensionField[dimensions.length];
            for (int d = 0; d < dimensions.length - 1; ++d) {
                CoordinateSystemAxis csa = cs.getAxis(d);
                if (!SpatialTemporalDimensionalityTypeProvider.isUnbounded(csa)) {
                    if (d == 0) {
                        dimensions[d] = new CustomCRSBoundedSpatialDimensionX(csa.getMinimumValue(), csa.getMaximumValue());
                        fields[d] = new CustomCRSSpatialField((CustomCRSBoundedSpatialDimensionX)dimensions[d], geometryPrecision);
                    }
                    if (d != 1) continue;
                    dimensions[d] = new CustomCRSBoundedSpatialDimensionY(csa.getMinimumValue(), csa.getMaximumValue());
                    fields[d] = new CustomCRSSpatialField((CustomCRSBoundedSpatialDimensionY)dimensions[d], geometryPrecision);
                    continue;
                }
                if (d == 0) {
                    dimensions[d] = new CustomCRSUnboundedSpatialDimensionX(4.0075017E7, (byte)d);
                    fields[d] = new CustomCRSSpatialField((CustomCRSUnboundedSpatialDimensionX)dimensions[d], geometryPrecision);
                }
                if (d != 1) continue;
                dimensions[d] = new CustomCRSUnboundedSpatialDimensionY(4.0075017E7, (byte)d);
                fields[d] = new CustomCRSSpatialField((CustomCRSUnboundedSpatialDimensionY)dimensions[d], geometryPrecision);
            }
            dimensions[dimensions.length - 1] = new TimeDefinition(options.periodicity);
            fields[dimensions.length - 1] = new TimeField(options.periodicity);
        }
        Object indexModel = null;
        indexModel = isDefaultCRS ? new BasicIndexModel(fields) : new CustomCrsIndexModel(fields, crsCode);
        String combinedArrayID = isDefaultCRS ? "ST_IDX_" + (Object)((Object)options.bias) + "_" + (Object)((Object)options.periodicity) : "ST_IDX_" + crsCode.substring(crsCode.indexOf(":") + 1) + "_" + (Object)((Object)options.bias) + "_" + (Object)((Object)options.periodicity);
        String combinedId = combinedArrayID;
        return new CustomNameIndex((NumericIndexStrategy)XZHierarchicalIndexFactory.createFullIncrementalTieredStrategy((NumericDimensionDefinition[])dimensions, (int[])new int[]{options.bias.getSpatialPrecision(), options.bias.getSpatialPrecision(), options.bias.getTemporalPrecision()}, (SFCFactory.SFCType)SFCFactory.SFCType.HILBERT, (Long)options.maxDuplicates), (CommonIndexModel)indexModel, combinedId);
    }

    private static boolean isUnbounded(CoordinateSystemAxis csa) {
        double min = csa.getMinimumValue();
        double max = csa.getMaximumValue();
        return !Double.isFinite(max) || !Double.isFinite(min);
    }

    public static CoordinateReferenceSystem decodeCRS(String crsCode) {
        CoordinateReferenceSystem crs = null;
        try {
            crs = CRS.decode((String)crsCode, (boolean)true);
        }
        catch (FactoryException e) {
            LOGGER.error("Unable to decode '" + crsCode + "' CRS", (Throwable)e);
            throw new RuntimeException("Unable to decode '" + crsCode + "' CRS", e);
        }
        return crs;
    }

    public static boolean isSpatialTemporal(Index index) {
        if (index == null) {
            return false;
        }
        return SpatialTemporalDimensionalityTypeProvider.isSpatialTemporal(index.getIndexStrategy());
    }

    public static boolean isSpatialTemporal(NumericIndexStrategy indexStrategy) {
        if (indexStrategy == null || indexStrategy.getOrderedDimensionDefinitions() == null) {
            return false;
        }
        NumericDimensionDefinition[] dimensions = indexStrategy.getOrderedDimensionDefinitions();
        if (dimensions.length < 3) {
            return false;
        }
        boolean hasLat = false;
        boolean hasLon = false;
        boolean hasTime = false;
        for (NumericDimensionDefinition definition : dimensions) {
            if (definition instanceof TimeDefinition) {
                hasTime = true;
                continue;
            }
            if (SpatialIndexUtils.isLatitudeDimension(definition)) {
                hasLat = true;
                continue;
            }
            if (!SpatialIndexUtils.isLongitudeDimension(definition)) continue;
            hasLon = true;
        }
        return hasTime && hasLat && hasLon;
    }

    public static class UnitConverter
    implements IStringConverter<TemporalBinningStrategy.Unit> {
        public TemporalBinningStrategy.Unit convert(String value) {
            TemporalBinningStrategy.Unit convertedValue = TemporalBinningStrategy.Unit.fromString(value);
            if (convertedValue == null) {
                throw new ParameterException("Value " + value + "can not be converted to Unit. Available values are: " + StringUtils.join((Object[])TemporalBinningStrategy.Unit.values(), (String)", ").toLowerCase(Locale.ENGLISH));
            }
            return convertedValue;
        }
    }

    public static class BiasConverter
    implements IStringConverter<Bias> {
        public Bias convert(String value) {
            Bias convertedValue = Bias.fromString(value);
            if (convertedValue == null) {
                throw new ParameterException("Value " + value + "can not be converted to an index bias. Available values are: " + StringUtils.join((Object[])Bias.values(), (String)", ").toLowerCase(Locale.ENGLISH));
            }
            return convertedValue;
        }
    }

    public static enum Bias {
        TEMPORAL,
        BALANCED,
        SPATIAL;


        public static Bias fromString(String code) {
            for (Bias output : Bias.values()) {
                if (!output.toString().equalsIgnoreCase(code)) continue;
                return output;
            }
            return null;
        }

        public int getSpatialPrecision() {
            switch (this) {
                case SPATIAL: {
                    return 25;
                }
                case TEMPORAL: {
                    return 10;
                }
            }
            return 20;
        }

        public int getTemporalPrecision() {
            switch (this) {
                case SPATIAL: {
                    return 10;
                }
                case TEMPORAL: {
                    return 40;
                }
            }
            return 20;
        }
    }
}

