/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.locationtech.geowave.core.cli.utils.ValueConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesUtils
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesUtils.class);
    private final Getter getter;

    public static Properties fromFile(String propertyFilePath) {
        return PropertiesUtils.fromFile(new File(propertyFilePath));
    }

    public static Properties fromFile(File propsFile) {
        Properties properties = null;
        if (propsFile != null && propsFile.exists()) {
            properties = new Properties();
            try {
                InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(propsFile), "UTF-8");
                if (isr != null) {
                    properties.load(isr);
                    isr.close();
                }
            }
            catch (FileNotFoundException fnfEx) {
                LOGGER.error("Specified properties file was not found: [" + fnfEx.getLocalizedMessage() + "]", (Throwable)fnfEx);
            }
            catch (IOException ioEx) {
                LOGGER.error("Exception occurred loading specified properties file: [" + ioEx.getLocalizedMessage() + "]", (Throwable)ioEx);
            }
        }
        return properties;
    }

    public PropertiesUtils(final Map properties) {
        this(new Getter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object get(String name) {
                return properties.get(name);
            }
        });
    }

    public PropertiesUtils(final Properties properties) {
        this(new Getter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object get(String name) {
                return properties != null ? properties.get(name) : null;
            }
        });
    }

    public PropertiesUtils(Getter getter) {
        this.getter = getter;
    }

    public boolean exists(String key) {
        return this.get(key, Object.class) != null;
    }

    private Object getPropertyValue(String name, boolean req) throws IllegalArgumentException {
        Object val = null;
        if (this.getter != null) {
            val = this.getter.get(name);
            if (val != null && val instanceof String && ((String)val).isEmpty()) {
                val = null;
            }
            if (val == null && req) {
                throw new IllegalArgumentException("Missing required property: " + name);
            }
        }
        return val;
    }

    public final <X> X get(String name, Class<X> clazz) throws IllegalArgumentException {
        Object val = this.getPropertyValue(name, true);
        return ValueConverter.convert(val, clazz);
    }

    public final <X> X get(String name, X def, Class<X> clazz) {
        Object val = this.getPropertyValue(name, false);
        return val == null ? def : ValueConverter.convert(val, clazz);
    }

    public final String getString(String name) throws IllegalArgumentException {
        return this.get(name, String.class);
    }

    public final String getString(String name, String def) {
        return this.get(name, def, String.class);
    }

    public final Integer getInt(String name) throws IllegalArgumentException {
        return this.get(name, Integer.class);
    }

    public final Integer getInt(String name, Integer def) {
        return this.get(name, def, Integer.class);
    }

    public final Long getLong(String name) throws IllegalArgumentException {
        return this.get(name, Long.class);
    }

    public final Long getLong(String name, Long def) {
        return this.get(name, def, Long.class);
    }

    public final Float getFloat(String name) throws IllegalArgumentException {
        return this.get(name, Float.class);
    }

    public final Float getFloat(String name, Float def) {
        return this.get(name, def, Float.class);
    }

    public final Double getDouble(String name) throws IllegalArgumentException {
        return this.get(name, Double.class);
    }

    public final Double getDouble(String name, Double def) {
        return this.get(name, def, Double.class);
    }

    public final BigInteger getBigInteger(String name) throws IllegalArgumentException {
        return this.get(name, BigInteger.class);
    }

    public final BigInteger getBigInteger(String name, BigInteger def) {
        return this.get(name, def, BigInteger.class);
    }

    public final BigDecimal getBigDecimal(String name) throws IllegalArgumentException {
        return this.get(name, BigDecimal.class);
    }

    public final BigDecimal getBigDecimal(String name, BigDecimal def) {
        return this.get(name, def, BigDecimal.class);
    }

    public final Byte getByte(String name) throws IllegalArgumentException {
        return this.get(name, Byte.class);
    }

    public final Byte getByte(String name, Byte def) {
        return this.get(name, def, Byte.class);
    }

    public final Boolean getBoolean(String name) throws IllegalArgumentException {
        return this.get(name, Boolean.class);
    }

    public final Boolean getBoolean(String name, Boolean def) {
        return this.get(name, def, Boolean.class);
    }

    public final URI getURI(String name) throws IllegalArgumentException {
        return this.get(name, URI.class);
    }

    public final URI getURI(String name, URI def) {
        return this.get(name, def, URI.class);
    }

    public final URL getURL(String name) throws IllegalArgumentException {
        return this.get(name, URL.class);
    }

    public final URL getURI(String name, URL def) {
        return this.get(name, def, URL.class);
    }

    public final String[] getStringArray(String name) throws IllegalArgumentException {
        return this.get(name, String[].class);
    }

    public final String[] getStringArray(String name, String[] def) {
        return this.get(name, def, String[].class);
    }

    public final Integer[] getIntArray(String name) throws IllegalArgumentException {
        return this.get(name, Integer[].class);
    }

    public final Integer[] getIntArray(String name, Integer[] def) {
        return this.get(name, def, Integer[].class);
    }

    public final Long[] getLongArray(String name) throws IllegalArgumentException {
        return this.get(name, Long[].class);
    }

    public final Long[] getLongArray(String name, Long[] def) {
        return this.get(name, def, Long[].class);
    }

    public final Float[] getFloatArray(String name) throws IllegalArgumentException {
        return this.get(name, Float[].class);
    }

    public final Float[] getFloatArray(String name, Float[] def) {
        return this.get(name, def, Float[].class);
    }

    public final Double[] getDoubleArray(String name) throws IllegalArgumentException {
        return this.get(name, Double[].class);
    }

    public final Double[] getDoubleArray(String name, Double[] def) {
        return this.get(name, def, Double[].class);
    }

    public final BigInteger[] getBigIntegerArray(String name) throws IllegalArgumentException {
        return this.get(name, BigInteger[].class);
    }

    public final BigInteger[] getBigIntegerArray(String name, BigInteger[] def) {
        return this.get(name, def, BigInteger[].class);
    }

    public final BigDecimal[] getBigDecimalArray(String name) throws IllegalArgumentException {
        return this.get(name, BigDecimal[].class);
    }

    public final BigDecimal[] getBigDecimalArray(String name, BigDecimal[] def) {
        return this.get(name, def, BigDecimal[].class);
    }

    public final URI[] getURIArray(String name) throws IllegalArgumentException {
        return this.get(name, URI[].class);
    }

    public final URI[] getURIArray(String name, URI[] def) {
        return this.get(name, def, URI[].class);
    }

    public final URI[] getURLArray(String name) throws IllegalArgumentException {
        return this.get(name, URI[].class);
    }

    public final URI[] getURLArray(String name, URI[] def) {
        return this.get(name, def, URI[].class);
    }

    public static interface Getter
    extends Serializable {
        public Object get(String var1);
    }
}

