/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.locationtech.geowave.core.cli.api.Operation;
import org.locationtech.geowave.core.cli.spi.CLIOperationProviderSpi;
import org.locationtech.geowave.core.cli.spi.OperationEntry;

public class OperationRegistry {
    private Map<Class<?>, OperationEntry> operationMapByClass = null;

    public OperationRegistry() {
        this.init();
    }

    public static OperationRegistry getInstance() {
        return OperationRegistryHolder.instance;
    }

    public OperationRegistry(List<OperationEntry> entries) {
        this.operationMapByClass = new HashMap();
        for (OperationEntry entry : entries) {
            this.operationMapByClass.put(entry.getOperationClass(), entry);
        }
    }

    private synchronized void init() {
        if (this.operationMapByClass == null) {
            this.operationMapByClass = new HashMap();
            for (CLIOperationProviderSpi operationProvider : ServiceLoader.load(CLIOperationProviderSpi.class)) {
                for (Class<?> clz : operationProvider.getOperations()) {
                    if (!Operation.class.isAssignableFrom(clz)) {
                        throw new RuntimeException("CLI operations must be assignable from Operation.class: " + clz.getCanonicalName());
                    }
                    OperationEntry entry = new OperationEntry(clz);
                    this.operationMapByClass.put(clz, entry);
                }
            }
            for (OperationEntry entry : this.operationMapByClass.values()) {
                if (entry.isTopLevel()) continue;
                OperationEntry parentEntry = this.operationMapByClass.get(entry.getParentOperationClass());
                if (parentEntry == null) {
                    throw new RuntimeException("Cannot find parent entry for " + entry.getOperationClass().getName());
                }
                if (parentEntry.isCommand()) {
                    throw new RuntimeException("Cannot have a command be a parent: " + entry.getClass().getCanonicalName());
                }
                parentEntry.addChild(entry);
            }
        }
    }

    public Collection<OperationEntry> getAllOperations() {
        return Collections.unmodifiableCollection(this.operationMapByClass.values());
    }

    public OperationEntry getOperation(Class<?> operationClass) {
        return this.operationMapByClass.get(operationClass);
    }

    private static class OperationRegistryHolder {
        public static final OperationRegistry instance = new OperationRegistry();

        private OperationRegistryHolder() {
        }
    }
}

