/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.Command;
import org.locationtech.geowave.core.cli.api.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OperationEntry {
    private static Logger LOGGER = LoggerFactory.getLogger(OperationEntry.class);
    private final String operationName;
    private final Class<?> operationClass;
    private final Class<?> parentOperationClass;
    private final Map<String, OperationEntry> children;
    private final boolean command;
    private final boolean topLevel;

    public OperationEntry(Class<?> operationClass) {
        this.operationClass = operationClass;
        GeowaveOperation operation = this.operationClass.getAnnotation(GeowaveOperation.class);
        if (operation == null) {
            throw new RuntimeException("Expected Operation class to use GeowaveOperation annotation: " + this.operationClass.getCanonicalName());
        }
        this.operationName = operation.name();
        this.parentOperationClass = operation.parentOperation();
        this.command = Command.class.isAssignableFrom(operationClass);
        this.topLevel = this.parentOperationClass == null || this.parentOperationClass == Object.class;
        this.children = new HashMap<String, OperationEntry>();
    }

    public Class<?> getParentOperationClass() {
        return this.parentOperationClass;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public Class<?> getOperationClass() {
        return this.operationClass;
    }

    public Collection<OperationEntry> getChildren() {
        return Collections.unmodifiableCollection(this.children.values());
    }

    public void addChild(OperationEntry child) {
        if (this.children.containsKey(child.getOperationName().toLowerCase(Locale.ENGLISH))) {
            throw new RuntimeException("Duplicate operation name: " + child.getOperationName() + " for " + this.getOperationClass().getName());
        }
        this.children.put(child.getOperationName().toLowerCase(Locale.ENGLISH), child);
    }

    public OperationEntry getChild(String name) {
        return this.children.get(name);
    }

    public boolean isCommand() {
        return this.command;
    }

    public boolean isTopLevel() {
        return this.topLevel;
    }

    public Operation createInstance() {
        try {
            return (Operation)this.operationClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOGGER.error("Unable to create new instance", (Throwable)e);
            return null;
        }
    }
}

