/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli.prefix;

import com.beust.jcommander.JCommander;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.locationtech.geowave.core.cli.prefix.JCommanderPrefixTranslator;
import org.locationtech.geowave.core.cli.prefix.JCommanderTranslationMap;
import org.locationtech.geowave.core.cli.prefix.TranslationEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCommanderPropertiesTransformer {
    private static Logger LOGGER = LoggerFactory.getLogger(JCommanderPropertiesTransformer.class);
    private final String propertyFormat;
    private final List<Object> objects = new ArrayList<Object>();

    public JCommanderPropertiesTransformer(String namespace) {
        this.propertyFormat = namespace == null ? "%s" : String.format("%s.%s", namespace, "%s");
    }

    public JCommanderPropertiesTransformer() {
        this(null);
    }

    public void addObject(Object object) {
        this.objects.add(object);
    }

    private Collection<TranslationEntry> generateEntries() {
        JCommanderPrefixTranslator translator = new JCommanderPrefixTranslator();
        for (Object obj : this.objects) {
            translator.addObject(obj);
        }
        JCommanderTranslationMap map = translator.translate();
        return map.getEntries().values();
    }

    public void transformToMap(Map<String, String> properties) {
        Properties props = new Properties();
        this.transformToProperties(props);
        for (String prop : props.stringPropertyNames()) {
            properties.put(prop, props.getProperty(prop));
        }
    }

    public void transformFromMap(Map<String, String> properties) {
        Properties props = new Properties();
        for (Map.Entry<String, String> prop : properties.entrySet()) {
            if (prop.getValue() == null) continue;
            props.setProperty(prop.getKey(), prop.getValue());
        }
        this.transformFromProperties(props);
    }

    public void transformToProperties(Properties toProperties) {
        for (TranslationEntry entry : this.generateEntries()) {
            String propertyName = entry.getAsPropertyName();
            propertyName = String.format(this.propertyFormat, propertyName);
            Object value = null;
            try {
                value = entry.getParam().get(entry.getObject());
            }
            catch (Exception e) {
                LOGGER.warn("Unable to set value", (Throwable)e);
                continue;
            }
            if (value == null) continue;
            if (entry.getParam().isDynamicParameter()) {
                Map props = (Map)value;
                for (Map.Entry prop : props.entrySet()) {
                    if (prop.getValue() == null) continue;
                    toProperties.put(String.format("%s.%s", propertyName, prop.getKey()), prop.getValue());
                }
                continue;
            }
            toProperties.put(propertyName, value.toString());
        }
    }

    public void transformFromProperties(Properties fromProperties) {
        JCommander jc = new JCommander();
        for (TranslationEntry entry : this.generateEntries()) {
            String propertyName = entry.getAsPropertyName();
            propertyName = String.format(this.propertyFormat, propertyName);
            if (entry.getParam().isDynamicParameter()) {
                HashMap<String, String> fromMap = new HashMap<String, String>();
                Set<String> propNames = fromProperties.stringPropertyNames();
                for (String propName : propNames) {
                    if (!propName.startsWith(propertyName)) continue;
                    String parsedName = propName.substring(propertyName.length() + 1);
                    fromMap.put(parsedName, fromProperties.getProperty(propName));
                }
                entry.getParam().set(entry.getObject(), fromMap);
                continue;
            }
            String value = fromProperties.getProperty(propertyName);
            if (value == null) continue;
            entry.getParam().set(entry.getObject(), jc.convertValue(entry.getParam(), entry.getParam().getType(), value));
        }
    }
}

