/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli.operations.config.security.crypto;

import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.locationtech.geowave.core.cli.operations.config.security.crypto.BaseEncryption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoWaveEncryption
extends BaseEncryption {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoWaveEncryption.class);

    public GeoWaveEncryption(String resourceLocation) {
        super(resourceLocation);
    }

    public GeoWaveEncryption() {
    }

    @Override
    public byte[] encryptBytes(byte[] valueToEncrypt) throws Exception {
        return Base64.encodeBase64((byte[])this.encryptValue(valueToEncrypt));
    }

    @Override
    public byte[] decryptBytes(byte[] valueToDecrypt) throws Exception {
        return this.decryptValue(Base64.decodeBase64((byte[])valueToDecrypt));
    }

    private PaddedBufferedBlockCipher getCipher(boolean encrypt) {
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()), (BlockCipherPadding)new PKCS7Padding());
        ParametersWithIV ivAndKey = new ParametersWithIV((CipherParameters)new KeyParameter(this.getKey().getEncoded()), this.salt);
        cipher.init(encrypt, (CipherParameters)ivAndKey);
        return cipher;
    }

    private byte[] encryptValue(byte[] encodedValue) throws Exception {
        LOGGER.trace("ENTER :: encyrpt");
        PaddedBufferedBlockCipher cipher = this.getCipher(true);
        byte[] output = new byte[cipher.getOutputSize(encodedValue.length)];
        int length = cipher.processBytes(encodedValue, 0, encodedValue.length, output, 0);
        try {
            cipher.doFinal(output, length);
        }
        catch (CryptoException e) {
            LOGGER.error("An error occurred performing encryption: " + e.getLocalizedMessage(), (Throwable)e);
        }
        return output;
    }

    private byte[] decryptValue(byte[] decodedValue) throws Exception {
        StringBuffer result = new StringBuffer();
        PaddedBufferedBlockCipher cipher = this.getCipher(false);
        byte[] output = new byte[cipher.getOutputSize(decodedValue.length)];
        int length = cipher.processBytes(decodedValue, 0, decodedValue.length, output, 0);
        cipher.doFinal(output, length);
        if (output != null && output.length != 0) {
            String retval = new String(output, "UTF-8");
            for (int i = 0; i < retval.length(); ++i) {
                char c = retval.charAt(i);
                if (c == '\u0000') continue;
                result.append(c);
            }
        }
        return result.toString().getBytes("UTF-8");
    }
}

