/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli.operations.config.security.crypto;

import java.io.File;
import java.security.Key;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.locationtech.geowave.core.cli.operations.config.options.ConfigOptions;
import org.locationtech.geowave.core.cli.operations.config.security.utils.SecurityUtils;
import org.locationtech.geowave.core.cli.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseEncryption {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseEncryption.class);
    public static String resourceName = "geowave_crypto_key.dat";
    private String resourceLocation;
    private Key key = null;
    protected byte[] salt = null;
    protected File tokenFile = null;
    private static final String PREFIX = "ENC{";
    private static final String SUFFIX = "}";
    public static final String WRAPPER = "ENC{}";
    private static final Pattern ENCCodePattern = Pattern.compile("ENC{".replace("{", "\\{") + "([^}]+)" + "}".replace("{", "\\{"));
    private final String KEY_ENCRYPTION_ALGORITHM = "AES";

    public BaseEncryption(String resourceLocation) {
        try {
            this.setResourceLocation(resourceLocation);
            this.init();
        }
        catch (Throwable t) {
            LOGGER.error(t.getLocalizedMessage(), t);
        }
    }

    public BaseEncryption() {
        this.init();
    }

    private void init() {
        try {
            this.checkForToken();
            this.setResourceLocation(this.tokenFile.getCanonicalPath());
            this.salt = "Ge0W@v3-Ro0t-K3y".getBytes("UTF-8");
            this.generateRootKeyFromToken();
        }
        catch (Throwable t) {
            LOGGER.error(t.getLocalizedMessage(), t);
        }
    }

    private void checkForToken() throws Throwable {
        this.tokenFile = this.getResourceLocation() != null ? new File(this.getResourceLocation()) : SecurityUtils.getFormattedTokenKeyFileForConfig(ConfigOptions.getDefaultPropertyFile());
        if (!this.tokenFile.exists()) {
            BaseEncryption.generateNewEncryptionToken(this.tokenFile);
        }
    }

    public static String getFormattedTokenFileName(String configFilename) {
        return String.format("%s.key", configFilename);
    }

    public static boolean generateNewEncryptionToken(File tokenFile) throws Exception {
        boolean success = false;
        try {
            LOGGER.info("Writing new encryption token to file at path {}", (Object)tokenFile.getCanonicalPath());
            org.apache.commons.io.FileUtils.writeStringToFile((File)tokenFile, (String)BaseEncryption.generateRandomSecretKey());
            LOGGER.info("Completed writing new encryption token to file");
            success = true;
        }
        catch (Exception ex) {
            LOGGER.error("An error occurred writing new encryption token to file: " + ex.getLocalizedMessage(), (Throwable)ex);
            throw ex;
        }
        return success;
    }

    public String getResourceLocation() {
        return this.resourceLocation;
    }

    public void setResourceLocation(String resourceLoc) throws Throwable {
        this.resourceLocation = resourceLoc;
    }

    public static boolean isProperlyWrapped(String data) {
        return ENCCodePattern.matcher(data).matches();
    }

    private String toString(byte[] data) {
        return Hex.encodeHexString((byte[])data);
    }

    private byte[] fromString(String data) {
        try {
            return Hex.decodeHex((char[])data.toCharArray());
        }
        catch (DecoderException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    private void generateRootKeyFromToken() throws Throwable {
        if (!this.tokenFile.exists()) {
            throw new Throwable("Token file not found at specified path [" + this.getResourceLocation() + "]");
        }
        try {
            String strPassword = FileUtils.readFileContent(this.tokenFile);
            char[] password = strPassword != null ? strPassword.trim().toCharArray() : null;
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            SecretKey tmp = factory.generateSecret(new PBEKeySpec(password, this.salt, 65536, 256));
            this.setKey(new SecretKeySpec(tmp.getEncoded(), "AES"));
        }
        catch (Exception ex) {
            LOGGER.error("An error occurred generating the root key from the specified token: " + ex.getLocalizedMessage(), (Throwable)ex);
        }
    }

    private static String generateRandomSecretKey() throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(256);
        SecretKey secretKey = keyGenerator.generateKey();
        byte[] encoded = secretKey.getEncoded();
        return DatatypeConverter.printBase64Binary((byte[])encoded);
    }

    protected void setKey(Key key) {
        this.key = key;
    }

    protected Key getKey() {
        return this.key;
    }

    public String encryptAndHexEncode(String data) throws Exception {
        if (data == null) {
            return null;
        }
        byte[] encryptedBytes = this.encryptBytes(data.getBytes("UTF-8"));
        return PREFIX + this.toString(encryptedBytes) + SUFFIX;
    }

    public String decryptHexEncoded(String data) throws Exception {
        if (data == null) {
            return null;
        }
        Matcher matcher = ENCCodePattern.matcher(data);
        if (matcher.matches()) {
            String codedString = matcher.group(1);
            return new String(this.decryptBytes(this.fromString(codedString)), "UTF-8");
        }
        return data;
    }

    public abstract byte[] encryptBytes(byte[] var1) throws Exception;

    public abstract byte[] decryptBytes(byte[] var1) throws Exception;
}

