/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli.operations.config.security;

import com.beust.jcommander.Parameters;
import java.io.File;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.Command;
import org.locationtech.geowave.core.cli.api.DefaultOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.core.cli.operations.config.ConfigSection;
import org.locationtech.geowave.core.cli.operations.config.options.ConfigOptions;
import org.locationtech.geowave.core.cli.operations.config.security.crypto.BaseEncryption;
import org.locationtech.geowave.core.cli.operations.config.security.utils.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GeowaveOperation(name="newcryptokey", parentOperation=ConfigSection.class)
@Parameters(commandDescription="Generate a new security cryptography key for use with configuration properties")
public class NewTokenCommand
extends DefaultOperation
implements Command {
    private static final Logger sLog = LoggerFactory.getLogger(NewTokenCommand.class);

    @Override
    public void execute(OperationParams params) {
        sLog.trace("ENTER :: execute");
        File geowaveDir = this.getGeoWaveDirectory();
        if (geowaveDir != null && geowaveDir.exists()) {
            File tokenFile = this.getSecurityTokenFile();
            if (tokenFile != null && tokenFile.exists()) {
                try {
                    sLog.info("Existing encryption token file exists already at path [" + tokenFile.getCanonicalPath());
                    sLog.info("Creating new encryption token and migrating all passwords in [{}] to be encrypted with new token", (Object)ConfigOptions.getDefaultPropertyFile().getCanonicalPath());
                    File backupFile = null;
                    boolean tokenBackedUp = false;
                    try {
                        backupFile = new File(tokenFile.getCanonicalPath() + ".bak");
                        tokenBackedUp = tokenFile.renameTo(backupFile);
                        this.generateNewEncryptionToken(tokenFile);
                    }
                    catch (Exception ex) {
                        sLog.error("An error occurred backing up existing token file. Please check directory and permissions and try again.", (Throwable)ex);
                    }
                    if (tokenBackedUp) {
                        Properties configProps = this.getGeoWaveConfigProperties(params);
                        if (configProps != null) {
                            boolean updated = false;
                            Set<Object> keySet = configProps.keySet();
                            Iterator<Object> keyIter = keySet.iterator();
                            if (keyIter != null) {
                                String configKey = null;
                                while (keyIter.hasNext()) {
                                    configKey = (String)keyIter.next();
                                    String configValue = configProps.getProperty(configKey);
                                    if (configValue == null || "".equals(configValue.trim()) || !BaseEncryption.isProperlyWrapped(configValue)) continue;
                                    String decryptedValue = SecurityUtils.decryptHexEncodedValue(configValue, backupFile.getCanonicalPath());
                                    String encryptedValue = SecurityUtils.encryptAndHexEncodeValue(decryptedValue, tokenFile.getCanonicalPath());
                                    configProps.put(configKey, encryptedValue);
                                    updated = true;
                                }
                            }
                            if (updated) {
                                ConfigOptions.writeProperties(this.getGeoWaveConfigFile(params), configProps);
                            }
                        }
                        backupFile.deleteOnExit();
                    }
                }
                catch (Exception ex) {
                    sLog.error("An error occurred creating a new encryption token: " + ex.getLocalizedMessage(), (Throwable)ex);
                }
            } else {
                this.generateNewEncryptionToken(tokenFile);
            }
        }
        sLog.trace("EXIT :: execute");
    }
}

