/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli.operations.config.options;

import com.beust.jcommander.Parameter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.locationtech.geowave.core.cli.Constants;
import org.locationtech.geowave.core.cli.VersionUtils;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.core.cli.operations.config.security.utils.SecurityUtils;
import org.locationtech.geowave.core.cli.utils.JCommanderParameterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigOptions {
    public static final String CHARSET = "ISO-8859-1";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigOptions.class);
    public static final String PROPERTIES_FILE_CONTEXT = "properties-file";
    public static final String GEOWAVE_CACHE_PATH = ".geowave";
    public static final String GEOWAVE_CACHE_FILE = "config.properties";
    @Parameter(names={"-cf", "--config-file"}, description="Override configuration file (default is <home>/.geowave/config.properties)")
    private String configFile;

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFilePath) {
        this.configFile = configFilePath;
    }

    public static File getDefaultPropertyPath() {
        String cachePath = String.format("%s%s%s", System.getProperty("user.home"), File.separator, GEOWAVE_CACHE_PATH);
        return new File(cachePath);
    }

    public static File getDefaultPropertyFile() {
        File defaultPath = ConfigOptions.getDefaultPropertyPath();
        String version = VersionUtils.getVersion();
        if (version != null) {
            return ConfigOptions.formatConfigFile(version, defaultPath);
        }
        String[] configFiles = defaultPath.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("-config.properties");
            }
        });
        if (configFiles != null && configFiles.length > 0) {
            String backupVersion = configFiles[0].substring(0, configFiles[0].length() - 18);
            return ConfigOptions.formatConfigFile(backupVersion, defaultPath);
        }
        return ConfigOptions.formatConfigFile("unknownversion", defaultPath);
    }

    public static File formatConfigFile(String version, File defaultPath) {
        String configFile = String.format("%s%s%s%s%s", defaultPath.getAbsolutePath(), File.separator, version, "-", GEOWAVE_CACHE_FILE);
        return new File(configFile);
    }

    public static boolean writeProperties(File configFile, Properties properties, Class<?> clazz, String namespacePrefix) {
        try {
            Properties tmp = new Properties(){
                private static final long serialVersionUID = 1L;

                @Override
                public Set<Object> keySet() {
                    return Collections.unmodifiableSet(new TreeSet<Object>(super.keySet()));
                }

                @Override
                public synchronized Enumeration<Object> keys() {
                    return Collections.enumeration(new TreeSet<Object>(super.keySet()));
                }
            };
            if (Boolean.parseBoolean(properties.getProperty("geowave.encryption.enabled", Constants.ENCRYPTION_ENABLED_DEFAULT)) && clazz != null) {
                Field[] fields = clazz.getDeclaredFields();
                for (Field field : fields) {
                    for (Annotation annotation : field.getAnnotations()) {
                        String value;
                        String storeFieldName;
                        Parameter parameter;
                        if (annotation.annotationType() != Parameter.class || !JCommanderParameterUtils.isPassword(parameter = (Parameter)annotation)) continue;
                        String string = storeFieldName = namespacePrefix != null && !"".equals(namespacePrefix.trim()) ? namespacePrefix + "." + field.getName() : field.getName();
                        if (!properties.containsKey(storeFieldName)) continue;
                        String encryptedValue = value = properties.getProperty(storeFieldName);
                        try {
                            File tokenFile = SecurityUtils.getFormattedTokenKeyFileForConfig(configFile);
                            encryptedValue = SecurityUtils.encryptAndHexEncodeValue(value, tokenFile.getAbsolutePath());
                        }
                        catch (Exception e) {
                            LOGGER.error("An error occurred encrypting specified password value: " + e.getLocalizedMessage(), (Throwable)e);
                            encryptedValue = value;
                        }
                        properties.setProperty(storeFieldName, encryptedValue);
                    }
                }
            }
            tmp.putAll((Map<?, ?>)properties);
            FileOutputStream str = new FileOutputStream(configFile);
            Object object = null;
            try {
                tmp.store(str, null);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (str != null) {
                    if (object != null) {
                        try {
                            str.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        str.close();
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Could not find the property file.", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            LOGGER.error("Exception writing property file.", (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean writeProperties(File configFile, Properties properties) {
        return ConfigOptions.writeProperties(configFile, properties, null, null);
    }

    public static Properties loadProperties(File configFile) {
        return ConfigOptions.loadProperties(configFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(File configFile, String pattern) {
        Properties properties = new Properties();
        if (configFile.exists()) {
            Pattern p = null;
            if (pattern != null) {
                p = Pattern.compile(pattern);
            }
            InputStream is = null;
            try {
                block40: {
                    if (p != null) {
                        try (FileInputStream input = new FileInputStream(configFile);
                             Scanner s = new Scanner((InputStream)input, CHARSET);){
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)out, CHARSET));
                            while (s.hasNext()) {
                                String line = s.nextLine();
                                if (!p.matcher(line).find()) continue;
                                writer.println(line);
                            }
                            writer.flush();
                            is = new ByteArrayInputStream(out.toByteArray());
                            break block40;
                        }
                    }
                    is = new FileInputStream(configFile);
                }
                properties.load(is);
            }
            catch (IOException e) {
                LOGGER.error("Could not find property cache file: " + configFile, (Throwable)e);
                Properties properties2 = null;
                return properties2;
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return properties;
    }

    public void prepare(OperationParams inputParams) {
        File propertyFile = null;
        propertyFile = this.getConfigFile() != null ? new File(this.getConfigFile()) : ConfigOptions.getDefaultPropertyFile();
        inputParams.getContext().put(PROPERTIES_FILE_CONTEXT, propertyFile);
    }
}

