/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli.operations.config;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.geowave.core.cli.Constants;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.core.cli.api.ServiceEnabledCommand;
import org.locationtech.geowave.core.cli.converters.PasswordConverter;
import org.locationtech.geowave.core.cli.operations.config.ConfigSection;
import org.locationtech.geowave.core.cli.operations.config.options.ConfigOptions;
import org.locationtech.geowave.core.cli.operations.config.security.utils.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GeowaveOperation(name="set", parentOperation=ConfigSection.class)
@Parameters(commandDescription="Set property name within cache")
public class SetCommand
extends ServiceEnabledCommand<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetCommand.class);
    @Parameter(description="<name> <value>")
    private List<String> parameters = new ArrayList<String>();
    @Parameter(names={"--password"}, description="Specify if the value being set is a password and should be encrypted in the configurations")
    private Boolean password = false;
    private boolean isRestCall = true;

    @Override
    public Boolean successStatusIs200() {
        return true;
    }

    @Override
    public void execute(OperationParams params) {
        this.isRestCall = false;
        this.computeResults(params);
    }

    @Override
    public Object computeResults(OperationParams params) {
        return this.setKeyValue(params);
    }

    private Object setKeyValue(OperationParams params) {
        File f = this.getGeoWaveConfigFile(params);
        Properties p = ConfigOptions.loadProperties(f);
        String key = null;
        String value = null;
        PasswordConverter converter = new PasswordConverter(null);
        if (this.parameters.size() == 1 && this.parameters.get(0).indexOf("=") != -1) {
            String[] parts = StringUtils.split((String)this.parameters.get(0), (String)"=");
            key = parts[0];
            value = !this.isRestCall && this.password.booleanValue() ? converter.convert(parts[1]) : parts[1];
        } else if (this.parameters.size() == 2) {
            key = this.parameters.get(0);
            value = !this.isRestCall && this.password.booleanValue() ? converter.convert(this.parameters.get(1)) : this.parameters.get(1);
        } else {
            throw new ParameterException("Requires: <name> <value>");
        }
        if (this.password.booleanValue()) {
            if (Boolean.parseBoolean(p.getProperty("geowave.encryption.enabled", Constants.ENCRYPTION_ENABLED_DEFAULT))) {
                try {
                    File tokenFile = SecurityUtils.getFormattedTokenKeyFileForConfig(this.getGeoWaveConfigFile());
                    value = SecurityUtils.encryptAndHexEncodeValue(value, tokenFile.getAbsolutePath());
                    LOGGER.debug("Value was successfully encrypted");
                }
                catch (Exception e) {
                    LOGGER.error("An error occurred encrypting the specified value: " + e.getLocalizedMessage(), (Throwable)e);
                }
            } else {
                LOGGER.debug("Value was set as a password, though encryption is currently disabled, so value was not encrypted. Please enable encryption and re-try.\nNote: To enable encryption, run the following command: geowave config set {}=true", (Object)"geowave.encryption.enabled");
            }
        }
        Object previousValue = p.setProperty(key, value);
        if (!ConfigOptions.writeProperties(f, p)) {
            throw new WritePropertiesException("Write failure");
        }
        return previousValue;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void setParameters(String key, String value) {
        this.parameters = new ArrayList<String>();
        this.parameters.add(key);
        this.parameters.add(value);
    }

    private static class WritePropertiesException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private WritePropertiesException(String string) {
            super(string);
        }
    }
}

