/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli.operations;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.Command;
import org.locationtech.geowave.core.cli.api.DefaultOperation;
import org.locationtech.geowave.core.cli.api.Operation;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.core.cli.operations.GeowaveTopLevelSection;
import org.locationtech.geowave.core.cli.parser.CommandLineOperationParams;
import org.locationtech.geowave.core.cli.prefix.JCommanderPrefixTranslator;
import org.locationtech.geowave.core.cli.prefix.JCommanderTranslationMap;
import org.locationtech.geowave.core.cli.spi.OperationEntry;
import org.locationtech.geowave.core.cli.spi.OperationRegistry;

@GeowaveOperation(name="help", parentOperation=GeowaveTopLevelSection.class)
@Parameters(commandDescription="Get descriptions of arguments for any GeoWave command")
public class HelpCommand
extends DefaultOperation
implements Command {
    @Override
    public boolean prepare(OperationParams inputParams) {
        super.prepare(inputParams);
        CommandLineOperationParams params = (CommandLineOperationParams)inputParams;
        params.setValidate(false);
        params.setAllowUnknown(true);
        return true;
    }

    @Override
    public void execute(OperationParams inputParams) {
        CommandLineOperationParams params = (CommandLineOperationParams)inputParams;
        ArrayList<String> nameArray = new ArrayList<String>();
        OperationRegistry registry = OperationRegistry.getInstance();
        StringBuilder builder = new StringBuilder();
        Operation lastOperation = null;
        for (Map.Entry<String, Operation> entry : params.getOperationMap().entrySet()) {
            if (entry.getValue() == this) continue;
            nameArray.add(entry.getKey());
            lastOperation = entry.getValue();
        }
        if (lastOperation == null) {
            lastOperation = registry.getOperation(GeowaveTopLevelSection.class).createInstance();
        }
        if (lastOperation != null) {
            String usage = lastOperation.usage();
            if (usage != null) {
                System.out.println(usage);
            } else {
                JCommanderPrefixTranslator translator = new JCommanderPrefixTranslator();
                translator.addObject(lastOperation);
                JCommanderTranslationMap map = translator.translate();
                map.createFacadeObjects();
                map.transformToFacade();
                JCommander jc = new JCommander();
                for (Object obj : map.getObjects()) {
                    jc.addObject(obj);
                }
                String programName = StringUtils.join(nameArray, (String)" ");
                jc.setProgramName(programName);
                jc.usage(builder);
                String operations = builder.toString().trim();
                builder = new StringBuilder();
                builder.append(operations);
                builder.append("\n\n");
                OperationEntry lastEntry = registry.getOperation(lastOperation.getClass());
                ArrayList<OperationEntry> children = new ArrayList<OperationEntry>(lastEntry.getChildren());
                Collections.sort(children, this.getOperationComparator());
                if (children.size() > 0) {
                    builder.append("  Commands:\n");
                    for (OperationEntry childEntry : children) {
                        Parameters p = childEntry.getOperationClass().getAnnotation(Parameters.class);
                        if (p != null && p.hidden()) continue;
                        builder.append(String.format("    %s%n", childEntry.getOperationName()));
                        if (p != null) {
                            String description = p.commandDescription();
                            builder.append(String.format("      %s%n", description));
                        } else {
                            builder.append("      <no description>\n");
                        }
                        builder.append("\n");
                    }
                }
                String output = builder.toString().trim();
                System.out.println(output);
            }
        }
    }

    private Comparator<OperationEntry> getOperationComparator() {
        return new Comparator<OperationEntry>(){

            @Override
            public int compare(OperationEntry o1, OperationEntry o2) {
                return o1.getOperationName().compareTo(o2.getOperationName());
            }
        };
    }
}

