/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli.converters;

import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.locationtech.geowave.core.cli.converters.GeoWaveBaseConverter;
import org.locationtech.geowave.core.cli.operations.config.options.ConfigOptions;
import org.locationtech.geowave.core.cli.utils.FileUtils;
import org.locationtech.geowave.core.cli.utils.PropertiesUtils;

public class PasswordConverter
extends GeoWaveBaseConverter<String> {
    public static final String DEFAULT_PASSWORD_DESCRIPTION = "Can be specified as 'pass:<password>', 'file:<local file containing the password>', 'propfile:<local properties file containing the password>:<property file key>', 'env:<variable containing the pass>', or stdin";
    public static final String STDIN = "stdin";
    private static final String SEPARATOR = ":";

    public PasswordConverter(String optionName) {
        super(optionName);
    }

    public String convert(String value) {
        for (KeyType keyType : KeyType.values()) {
            if (!keyType.matches(value)) continue;
            return keyType.convert(value);
        }
        return value;
    }

    @Override
    public boolean isPassword() {
        return true;
    }

    @Override
    public boolean isRequired() {
        return true;
    }

    protected Properties getGeoWaveConfigProperties() {
        File geowaveConfigPropsFile = this.getGeoWaveConfigFile();
        return ConfigOptions.loadProperties(geowaveConfigPropsFile);
    }

    protected File getGeoWaveConfigFile() {
        return ConfigOptions.getDefaultPropertyFile();
    }

    private static enum KeyType {
        PASS("pass:"){

            @Override
            String process(String password) {
                return password;
            }
        }
        ,
        ENV("env:"){

            @Override
            String process(String envVariable) {
                return System.getenv(envVariable);
            }
        }
        ,
        FILE("file:"){

            @Override
            String process(String value) {
                try {
                    String password = FileUtils.readFileContent(new File(value));
                    if (password != null && !"".equals(password.trim())) {
                        return password;
                    }
                }
                catch (Exception ex) {
                    throw new ParameterException((Throwable)ex);
                }
                return null;
            }
        }
        ,
        PROPFILE("propfile:"){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            String process(String value) {
                if (value == null || "".equals(value.trim())) throw new ParameterException((Throwable)new Exception("No properties file specified"));
                if (value.indexOf(PasswordConverter.SEPARATOR) == -1) throw new ParameterException("Property File values are expected in input format <property file path>::<property key>");
                String propertyFilePath = value.split(PasswordConverter.SEPARATOR)[0];
                String propertyKey = value.split(PasswordConverter.SEPARATOR)[1];
                if (propertyFilePath == null || "".equals(propertyFilePath.trim())) throw new ParameterException("No properties file path specified");
                File propsFile = new File(propertyFilePath = propertyFilePath.trim());
                if (propsFile != null && propsFile.exists()) {
                    Properties properties = PropertiesUtils.fromFile(propsFile);
                    if (propertyKey != null && !"".equals(propertyKey.trim())) {
                        propertyKey = propertyKey.trim();
                    }
                    if (properties == null || !properties.containsKey(propertyKey)) return value;
                    return properties.getProperty(propertyKey);
                }
                try {
                    throw new ParameterException((Throwable)new FileNotFoundException(propsFile != null ? "Properties file not found at path: " + propsFile.getCanonicalPath() : "No properties file specified"));
                }
                catch (IOException e) {
                    throw new ParameterException((Throwable)e);
                }
            }
        }
        ,
        STDIN("stdin"){
            private String input = null;

            @Override
            public boolean matches(String value) {
                return this.prefix.equals(value);
            }

            @Override
            String process(String value) {
                if (this.input == null) {
                    this.input = GeoWaveBaseConverter.promptAndReadPassword("Enter password: ");
                }
                return this.input;
            }
        }
        ,
        DEFAULT(""){

            @Override
            String process(String password) {
                return password;
            }
        };

        String prefix;

        private KeyType(String prefix) {
            this.prefix = prefix;
        }

        public boolean matches(String value) {
            return value.startsWith(this.prefix);
        }

        public String convert(String value) {
            return this.process(value.substring(this.prefix.length()));
        }

        String process(String value) {
            return value;
        }
    }
}

