/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli.api;

import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.Command;
import org.locationtech.geowave.core.cli.api.DefaultOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;

public abstract class ServiceEnabledCommand<T>
extends DefaultOperation
implements Command {
    protected String path = null;

    public abstract T computeResults(OperationParams var1) throws Exception;

    public boolean runAsync() {
        return false;
    }

    public HttpMethod getMethod() {
        String path = this.getPath();
        if (path.contains("get") || path.contains("list")) {
            return HttpMethod.GET;
        }
        return HttpMethod.POST;
    }

    public Boolean successStatusIs200() {
        switch (this.getMethod()) {
            case POST: {
                return false;
            }
        }
        return true;
    }

    public String getPath() {
        if (this.path == null) {
            this.path = this.defaultGetPath();
        }
        return this.path.replace("geowave", "v0");
    }

    public String getId() {
        return this.defaultId();
    }

    protected String getName() {
        return null;
    }

    private String defaultId() {
        if (this.getClass().isAnnotationPresent(GeowaveOperation.class)) {
            GeowaveOperation op = this.getClass().getAnnotation(GeowaveOperation.class);
            return op.parentOperation().getName() + "." + op.name();
        }
        if (this.getName() != null && !this.getName().trim().isEmpty()) {
            return this.getName();
        }
        return this.getClass().getTypeName();
    }

    private String defaultGetPath() {
        Class<?> operation = this.getClass();
        if (operation.isAnnotationPresent(GeowaveOperation.class)) {
            return ServiceEnabledCommand.pathFor(operation, this.getName()).substring(1);
        }
        if (this.getName() != null && !this.getName().trim().isEmpty()) {
            return this.getName();
        }
        return operation.getTypeName();
    }

    private static String pathFor(Class<?> operation, String resourcePathOverride) {
        if (operation == Object.class) {
            return "";
        }
        GeowaveOperation operationInfo = operation.getAnnotation(GeowaveOperation.class);
        return ServiceEnabledCommand.pathFor(operationInfo.parentOperation(), null) + "/" + ServiceEnabledCommand.resolveName(operationInfo.name(), resourcePathOverride);
    }

    private static String resolveName(String operationName, String resourcePathOverride) {
        if (resourcePathOverride == null || resourcePathOverride.trim().isEmpty()) {
            return operationName;
        }
        return resourcePathOverride;
    }

    public static enum HttpMethod {
        GET,
        POST,
        PUT,
        PATCH,
        DELETE;

    }
}

