/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli.api;

import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.locationtech.geowave.core.cli.api.Operation;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.core.cli.operations.config.options.ConfigOptions;
import org.locationtech.geowave.core.cli.operations.config.security.crypto.BaseEncryption;
import org.locationtech.geowave.core.cli.operations.config.security.utils.SecurityUtils;
import org.locationtech.geowave.core.cli.spi.DefaultConfigProviderSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultOperation
implements Operation {
    private static final Logger sLog = LoggerFactory.getLogger(DefaultOperation.class);
    private File geowaveDirectory = null;
    private File geowaveConfigFile = null;
    private File securityTokenFile = null;

    @Override
    public boolean prepare(OperationParams params) throws ParameterException {
        try {
            this.checkForGeoWaveDirectory(params);
        }
        catch (Exception e) {
            throw new ParameterException("Error occurred during preparing phase: " + e.getLocalizedMessage(), (Throwable)e);
        }
        return true;
    }

    private void checkForToken() {
        File tokenFile = SecurityUtils.getFormattedTokenKeyFileForConfig(this.geowaveConfigFile);
        if (tokenFile == null || !tokenFile.exists()) {
            this.generateNewEncryptionToken(tokenFile);
        }
        this.setSecurityTokenFile(tokenFile);
    }

    private void checkForGeoWaveDirectory(OperationParams params) throws Exception {
        this.setGeoWaveConfigFile(this.getGeoWaveConfigFile(params));
        if (this.getGeoWaveConfigFile(params) == null) {
            this.setGeoWaveConfigFile(ConfigOptions.getDefaultPropertyFile());
            this.setDefaultConfigProperties(params);
        }
        this.setGeowaveDirectory(this.getGeoWaveConfigFile(params).getParentFile());
        if (!this.getGeoWaveDirectory().exists()) {
            try {
                boolean created = this.getGeoWaveDirectory().mkdir();
                if (!created) {
                    sLog.error("An error occurred creating a user '.geowave' in home directory");
                }
            }
            catch (Exception e) {
                sLog.error("An error occurred creating a user '.geowave' in home directory: " + e.getLocalizedMessage(), (Throwable)e);
                throw new ParameterException((Throwable)e);
            }
        }
        if (!this.getGeoWaveConfigFile(params).exists()) {
            try {
                if (!this.getGeoWaveConfigFile(params).createNewFile()) {
                    throw new Exception("Could not create property cache file: " + this.getGeoWaveConfigFile(params));
                }
            }
            catch (IOException e) {
                sLog.error("Could not create property cache file: " + this.getGeoWaveConfigFile(params), (Throwable)e);
                throw new ParameterException((Throwable)e);
            }
            this.setDefaultConfigProperties(params);
        }
        this.checkForToken();
    }

    protected boolean generateNewEncryptionToken(File tokenFile) {
        try {
            return BaseEncryption.generateNewEncryptionToken(tokenFile);
        }
        catch (Exception ex) {
            sLog.error("An error occurred writing new encryption token to file: " + ex.getLocalizedMessage(), (Throwable)ex);
            return false;
        }
    }

    public File getSecurityTokenFile() {
        return this.securityTokenFile;
    }

    public void setSecurityTokenFile(File securityTokenFile) {
        this.securityTokenFile = securityTokenFile;
    }

    public File getGeoWaveDirectory() {
        return this.geowaveDirectory;
    }

    private void setGeowaveDirectory(File geowaveDirectory) {
        this.geowaveDirectory = geowaveDirectory;
    }

    public File getGeoWaveConfigFile(OperationParams params) {
        if (this.getGeoWaveConfigFile() == null) {
            this.setGeoWaveConfigFile((File)params.getContext().get("properties-file"));
        }
        return this.getGeoWaveConfigFile();
    }

    public File getGeoWaveConfigFile() {
        return this.geowaveConfigFile;
    }

    private void setGeoWaveConfigFile(File geowaveConfigFile) {
        this.geowaveConfigFile = geowaveConfigFile;
    }

    public Properties getGeoWaveConfigProperties(OperationParams params, String filter) {
        return ConfigOptions.loadProperties(this.getGeoWaveConfigFile(params), filter);
    }

    public Properties getGeoWaveConfigProperties(OperationParams params) {
        return this.getGeoWaveConfigProperties(params, null);
    }

    public Properties getGeoWaveConfigProperties() {
        return ConfigOptions.loadProperties(this.getGeoWaveConfigFile());
    }

    private void setDefaultConfigProperties(OperationParams params) {
        Properties defaultProperties = new Properties();
        for (DefaultConfigProviderSpi defaultPropertiesProvider : ServiceLoader.load(DefaultConfigProviderSpi.class)) {
            defaultProperties.putAll((Map<?, ?>)defaultPropertiesProvider.getDefaultConfig());
        }
        ConfigOptions.writeProperties(this.getGeoWaveConfigFile(), defaultProperties);
    }

    @Override
    public String usage() {
        return null;
    }
}

