/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli;

import com.beust.jcommander.JCommander;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionUtils.class);
    private static final String BUILD_PROPERTIES_FILE_NAME = "build.properties";
    private static final String VERSION_PROPERTY_KEY = "project.version";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties getBuildProperties() {
        Properties props = new Properties();
        try (InputStream stream = VersionUtils.class.getClassLoader().getResourceAsStream(BUILD_PROPERTIES_FILE_NAME);){
            if (stream != null) {
                props.load(stream);
            }
            Properties properties = props;
            return properties;
        }
        catch (IOException e) {
            LOGGER.warn("Cannot read GeoWave build properties to show version information", (Throwable)e);
            JCommander.getConsole().print("Cannot read GeoWave build properties to show version information: " + e.getMessage());
            return props;
        }
    }

    public static String getVersion() {
        return VersionUtils.getBuildProperties().getProperty(VERSION_PROPERTY_KEY);
    }

    public static List<String> getVersionInfo() {
        List<String> buildAndPropertyList = Arrays.asList(VersionUtils.getBuildProperties().toString().split(","));
        Collections.sort(buildAndPropertyList.subList(1, buildAndPropertyList.size()));
        return buildAndPropertyList;
    }

    public static String asLineDelimitedString(List<String> value) {
        StringBuilder str = new StringBuilder();
        for (String v : value) {
            str.append(v).append('\n');
        }
        return str.toString();
    }

    public static void printVersionInfo() {
        List<String> buildAndPropertyList = VersionUtils.getVersionInfo();
        for (String str : buildAndPropertyList) {
            JCommander.getConsole().println(str);
        }
    }
}

