/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli;

import com.beust.jcommander.JCommander;
import org.locationtech.geowave.core.cli.api.Command;
import org.locationtech.geowave.core.cli.api.Operation;
import org.locationtech.geowave.core.cli.operations.ExplainCommand;
import org.locationtech.geowave.core.cli.operations.GeowaveTopLevelSection;
import org.locationtech.geowave.core.cli.operations.HelpCommand;
import org.locationtech.geowave.core.cli.parser.CommandLineOperationParams;
import org.locationtech.geowave.core.cli.parser.OperationParser;
import org.locationtech.geowave.core.cli.spi.OperationEntry;
import org.locationtech.geowave.core.cli.spi.OperationRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoWaveMain {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoWaveMain.class);

    public static void main(String[] args) {
        OperationParser parser = new OperationParser(GeoWaveMain.prepRegistry());
        CommandLineOperationParams params = parser.parse(GeowaveTopLevelSection.class, args);
        if (params.getSuccessCode() == 0) {
            GeoWaveMain.run(params);
        }
        if (params.getSuccessCode() < 0) {
            GeoWaveMain.doHelp(params);
            LOGGER.debug(params.getSuccessMessage(), params.getSuccessException());
            JCommander.getConsole().println("\n" + params.getSuccessMessage());
        } else if (params.getSuccessCode() == 0 && !params.isCommandPresent()) {
            GeoWaveMain.doHelp(params);
        }
        System.exit(params.getSuccessCode());
    }

    private static void run(CommandLineOperationParams params) {
        for (Operation operation : params.getOperationMap().values()) {
            if (!(operation instanceof Command)) continue;
            try {
                ((Command)operation).execute(params);
            }
            catch (Exception p) {
                LOGGER.warn("Unable to execute operation", (Throwable)p);
                params.setSuccessCode(-1);
                params.setSuccessMessage(String.format("Unable to execute operation: %s", p.getMessage()));
                params.setSuccessException(p);
            }
            break;
        }
    }

    private static OperationRegistry prepRegistry() {
        OperationRegistry registry = OperationRegistry.getInstance();
        OperationEntry explainCommand = registry.getOperation(ExplainCommand.class);
        OperationEntry helpCommand = registry.getOperation(HelpCommand.class);
        OperationEntry topLevel = registry.getOperation(GeowaveTopLevelSection.class);
        for (OperationEntry entry : topLevel.getChildren()) {
            if (entry == helpCommand || entry == explainCommand) continue;
            helpCommand.addChild(entry);
            explainCommand.addChild(entry);
        }
        return registry;
    }

    private static void doHelp(CommandLineOperationParams params) {
        HelpCommand command = new HelpCommand();
        command.execute(params);
    }
}

