/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.sentinel2.amazon;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import it.geosolutions.imageio.plugins.jp2ecw.JP2GDALEcwImageReaderSpi;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverageio.gdal.jp2ecw.JP2ECWReader;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.geowave.format.sentinel2.BandFeatureIterator;
import org.locationtech.geowave.format.sentinel2.DownloadRunner;
import org.locationtech.geowave.format.sentinel2.RasterBandData;
import org.locationtech.geowave.format.sentinel2.SceneFeatureIterator;
import org.locationtech.geowave.format.sentinel2.Sentinel2ImageryProvider;
import org.locationtech.jts.geom.Envelope;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonImageryProvider
extends Sentinel2ImageryProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmazonImageryProvider.class);
    private static final String SCENES_TYPE_NAME = "aws-sentinel2-scene";
    private static final String BANDS_TYPE_NAME = "aws-sentinel2-band";
    private static final double NO_DATA_VALUE = 0.0;
    private static final String SCENES_SEARCH_URL = "http://opensearch.sentinel-hub.com/resto/api/collections/%s/search.json?";
    private static final String DOWNLOAD_URL = "http://sentinel-s2-l1c.s3-website.eu-central-1.amazonaws.com/";
    private static final FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();
    private static final String AWS_RASTER_BANDS_NAMES = "B1;B2;B3;B4;B5;B6;B7;B8;B9;B10;B11;B12;B8A;TCI";
    private static final Map<String, String> AWS_SCENE_RESOURCE_NAMES = new HashMap<String, String>();
    private static final Map<String, String> AWS_COLLECTION_NAMES = new HashMap<String, String>();
    private static int JP2ECW_PLUGIN_AVAILABLE_FLAG = 0;

    @Override
    public String providerName() {
        return "AWS";
    }

    @Override
    public String description() {
        return "Sentinel2 provider for the Amazon Web Services (AWS) repository";
    }

    @Override
    public String[] collections() {
        return new String[]{"SENTINEL2"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAvailable() {
        Map<String, String> map = AWS_SCENE_RESOURCE_NAMES;
        synchronized (map) {
            if (JP2ECW_PLUGIN_AVAILABLE_FLAG == 0) {
                try {
                    String ncs_env;
                    System.err.println("Testing whether the JP2ECW plugin for GDAL is available...");
                    Class.forName("it.geosolutions.imageio.plugins.jp2ecw.JP2GDALEcwImageReaderSpi");
                    boolean available = new JP2GDALEcwImageReaderSpi().isAvailable();
                    if (available && (ncs_env = System.getenv("NCS_USER_PREFS")) != null && ncs_env.length() == 0) {
                        LOGGER.warn("NCS_USER_PREFS environment variable is empty, ignore JP2ECW plugin.");
                        available = false;
                    }
                    if (available) {
                        System.err.println("JP2ECW plugin is available!");
                        JP2ECW_PLUGIN_AVAILABLE_FLAG = 1;
                        return true;
                    }
                }
                catch (Throwable e) {
                    LOGGER.error("Unable to validate the JP2ECW plugin for GDAL", e);
                }
                System.err.println("The native JP2ECW plugin for GDAL seems not to be set in your GDAL_DRIVER_PATH environment variable. AWS Sentinel2 provider is not available.");
                JP2ECW_PLUGIN_AVAILABLE_FLAG = 2;
                return false;
            }
        }
        return JP2ECW_PLUGIN_AVAILABLE_FLAG == 1;
    }

    @Override
    public SimpleFeatureTypeBuilder sceneFeatureTypeBuilder() throws NoSuchAuthorityCodeException, FactoryException {
        return SceneFeatureIterator.defaultSceneFeatureTypeBuilder(SCENES_TYPE_NAME);
    }

    @Override
    public SimpleFeatureTypeBuilder bandFeatureTypeBuilder() throws NoSuchAuthorityCodeException, FactoryException {
        return BandFeatureIterator.defaultBandFeatureTypeBuilder(BANDS_TYPE_NAME);
    }

    @Override
    public Iterator<SimpleFeature> searchScenes(File scenesDir, String collection, String platform, String location, Envelope envelope, Date startDate, Date endDate, int orbitNumber, int relativeOrbitNumber) throws IOException {
        class AmazonJSONFeatureIterator
        extends Sentinel2ImageryProvider.JSONFeatureIterator {
            public AmazonJSONFeatureIterator(Sentinel2ImageryProvider provider, SimpleFeatureType featureType, Iterator<?> iterator) {
                super(provider, featureType, iterator);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SimpleFeature next() {
                SimpleFeature feature;
                block14: {
                    feature = super.next();
                    JSONObject jsonObject = null;
                    if (feature != null && (jsonObject = super.currentObject()) != null) {
                        InputStream inputStream;
                        block13: {
                            JSONObject properties = (JSONObject)jsonObject.get("properties");
                            String s3Path = properties.getString("s3Path");
                            String[] path = s3Path.split("/");
                            feature.setAttribute("location", (Object)("T" + path[1] + path[2] + path[3]));
                            feature.setAttribute("bands", (Object)AmazonImageryProvider.AWS_RASTER_BANDS_NAMES);
                            feature.setAttribute("sceneDownloadUrl", (Object)(AmazonImageryProvider.DOWNLOAD_URL + s3Path));
                            inputStream = null;
                            ByteArrayOutputStream outputStream = null;
                            try {
                                URL url = new URL(AmazonImageryProvider.DOWNLOAD_URL + s3Path + "/productInfo.json");
                                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                                connection.setUseCaches(false);
                                connection.setRequestProperty("User-Agent", "Mozilla/5.0");
                                connection.setRequestMethod("GET");
                                inputStream = connection.getInputStream();
                                outputStream = new ByteArrayOutputStream();
                                IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
                                String geoJson = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
                                JSONObject response = JSONObject.fromObject((Object)geoJson);
                                String name = response.getString("name");
                                String id = response.getString("id");
                                feature.setAttribute("entityId", (Object)id);
                                feature.setAttribute("productIdentifier", (Object)name);
                                feature.setAttribute("collection", (Object)"SENTINEL2");
                                String platform = name.substring(0, 4);
                                String level = (String)feature.getAttribute("processingLevel");
                                if (!level.startsWith("LEVEL")) {
                                    feature.setAttribute("processingLevel", (Object)("LEVEL" + level));
                                }
                                if (platform.equalsIgnoreCase("S2A_")) {
                                    feature.setAttribute("platform", (Object)"SENTINEL2A");
                                } else if (platform.equalsIgnoreCase("S2B_")) {
                                    feature.setAttribute("platform", (Object)"SENTINEL2B");
                                }
                                if (outputStream == null) break block13;
                            }
                            catch (IOException e) {
                                LOGGER.warn("Unable to get 'productInfo.json' of '" + s3Path + "'", (Throwable)e);
                                break block14;
                            }
                            finally {
                                if (outputStream != null) {
                                    IOUtils.closeQuietly(outputStream);
                                    outputStream = null;
                                }
                                if (inputStream != null) {
                                    IOUtils.closeQuietly(inputStream);
                                    inputStream = null;
                                }
                            }
                            IOUtils.closeQuietly((OutputStream)outputStream);
                            outputStream = null;
                        }
                        if (inputStream != null) {
                            IOUtils.closeQuietly((InputStream)inputStream);
                            inputStream = null;
                        }
                    }
                }
                return feature;
            }
        }
        AmazonJSONFeatureIterator amazonJSONFeatureIterator;
        InputStream inputStream;
        block15: {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Object extraFilter = Filter.INCLUDE;
            String searchUrl = String.format(SCENES_SEARCH_URL, AWS_COLLECTION_NAMES.get(collection));
            if (platform != null && platform.length() > 0) {
                extraFilter = FF.equals((Expression)FF.property("platform"), (Expression)FF.literal((Object)platform));
            }
            if (location != null && location.length() > 0) {
                PropertyIsEqualTo temp = FF.equals((Expression)FF.property("location"), (Expression)FF.literal((Object)location));
                extraFilter = extraFilter.equals(Filter.INCLUDE) ? temp : FF.and((Filter)extraFilter, (Filter)temp);
            }
            if (envelope != null && !envelope.isNull()) {
                searchUrl = searchUrl + String.format(Locale.ENGLISH, "box=%.6f,%.6f,%.6f,%.6f&", envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
            }
            if (startDate != null) {
                searchUrl = searchUrl + "startDate=" + dateFormat.format(startDate) + "&";
            }
            if (endDate != null) {
                searchUrl = searchUrl + "completionDate=" + dateFormat.format(endDate) + "&";
            }
            if (orbitNumber > 0) {
                searchUrl = searchUrl + "orbitNumber=" + orbitNumber + "&";
            }
            if (relativeOrbitNumber > 0) {
                searchUrl = searchUrl + "relativeOrbitNumber=" + relativeOrbitNumber + "&";
            }
            searchUrl = searchUrl.substring(0, searchUrl.length() - 1);
            inputStream = null;
            ByteArrayOutputStream outputStream = null;
            try {
                URL url = new URL(searchUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setUseCaches(false);
                connection.setRequestProperty("User-Agent", "Mozilla/5.0");
                connection.setRequestMethod("GET");
                inputStream = connection.getInputStream();
                outputStream = new ByteArrayOutputStream();
                IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
                String geoJson = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
                JSONObject response = JSONObject.fromObject((Object)geoJson);
                JSONArray features = response.getJSONArray("features");
                SimpleFeatureTypeBuilder typeBuilder = this.sceneFeatureTypeBuilder();
                SimpleFeatureType type = typeBuilder.buildFeatureType();
                AmazonJSONFeatureIterator featureIterator = new AmazonJSONFeatureIterator(this, type, features.iterator());
                if (!extraFilter.equals(Filter.INCLUDE)) {
                    SceneFeatureIterator.CqlFilterPredicate filterPredicate = new SceneFeatureIterator.CqlFilterPredicate((Filter)extraFilter);
                    featureIterator = Iterators.filter((Iterator)featureIterator, (Predicate)filterPredicate);
                }
                amazonJSONFeatureIterator = featureIterator;
                if (outputStream == null) break block15;
            }
            catch (FactoryException e) {
                try {
                    throw new IOException(e);
                }
                catch (Throwable throwable) {
                    if (outputStream != null) {
                        IOUtils.closeQuietly(outputStream);
                        outputStream = null;
                    }
                    if (inputStream != null) {
                        IOUtils.closeQuietly(inputStream);
                        inputStream = null;
                    }
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)outputStream);
            outputStream = null;
        }
        if (inputStream != null) {
            IOUtils.closeQuietly((InputStream)inputStream);
            inputStream = null;
        }
        return amazonJSONFeatureIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean downloadFile(String downloadUrl, File sceneDir, String resourceName) throws IOException {
        boolean bl;
        InputStream inputStream;
        block8: {
            String fileName = AWS_SCENE_RESOURCE_NAMES.get(resourceName);
            String resourceUrl = downloadUrl + "/" + fileName;
            File resourceFile = new File(sceneDir + File.separator + fileName);
            inputStream = null;
            FileOutputStream outputStream = null;
            try {
                URL url = new URL(resourceUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setUseCaches(false);
                connection.setRequestProperty("User-Agent", "Mozilla/5.0");
                connection.setRequestMethod("GET");
                inputStream = connection.getInputStream();
                outputStream = new FileOutputStream(resourceFile);
                String displaySize = FileUtils.byteCountToDisplaySize((long)inputStream.available());
                System.out.print("Downloading File '" + resourceUrl + "' (" + displaySize + ")");
                IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
                IOUtils.closeQuietly((OutputStream)outputStream);
                displaySize = FileUtils.byteCountToDisplaySize((long)resourceFile.length());
                System.out.println(" -> ok: (" + displaySize + ")");
                bl = true;
                if (outputStream == null) break block8;
            }
            catch (IOException e) {
                boolean bl2;
                block9: {
                    try {
                        LOGGER.error("Unable to download '" + resourceUrl + "'", (Throwable)e);
                        System.out.println(" -> error: " + e.getMessage());
                        bl2 = false;
                        if (outputStream == null) break block9;
                    }
                    catch (Throwable throwable) {
                        if (outputStream != null) {
                            outputStream.close();
                            outputStream = null;
                        }
                        if (inputStream != null) {
                            IOUtils.closeQuietly(inputStream);
                            inputStream = null;
                        }
                        throw throwable;
                    }
                    outputStream.close();
                    outputStream = null;
                }
                if (inputStream != null) {
                    IOUtils.closeQuietly((InputStream)inputStream);
                    inputStream = null;
                }
                return bl2;
            }
            outputStream.close();
            outputStream = null;
        }
        if (inputStream != null) {
            IOUtils.closeQuietly((InputStream)inputStream);
            inputStream = null;
        }
        return bl;
    }

    @Override
    public boolean downloadScene(SimpleFeature scene, String workspaceDir, String userIdent, String password) throws IOException {
        String productId = (String)scene.getAttribute("productIdentifier");
        System.out.println("\nDownloading scene '" + productId + "'");
        System.out.println("Wait please... ");
        File sceneDir = DownloadRunner.getSceneDirectory(scene, workspaceDir);
        if (!sceneDir.exists() && !sceneDir.mkdirs()) {
            LOGGER.error("Unable to create directory '" + sceneDir.getAbsolutePath() + "'");
            return false;
        }
        String downloadUrl = (String)scene.getAttribute("sceneDownloadUrl");
        int successCount = 0;
        if (AmazonImageryProvider.downloadFile(downloadUrl, sceneDir, "productInfo")) {
            ++successCount;
        }
        if (AmazonImageryProvider.downloadFile(downloadUrl, sceneDir, "preview")) {
            ++successCount;
        }
        return successCount == 2;
    }

    @Override
    public RasterBandData getCoverage(SimpleFeature band, String workspaceDir) throws IOException {
        File sceneDir = DownloadRunner.getSceneDirectory(band, workspaceDir);
        String entityId = (String)band.getAttribute("entityId");
        String productId = (String)band.getAttribute("productIdentifier");
        String bandName = (String)band.getAttribute("band");
        File file = new File(sceneDir + File.separator + AWS_SCENE_RESOURCE_NAMES.get(bandName));
        if (!file.exists()) {
            String downloadUrl = (String)band.getAttribute("sceneDownloadUrl");
            AmazonImageryProvider.downloadFile(downloadUrl, sceneDir, bandName);
        }
        if (file.exists()) {
            JP2ECWReader reader = new JP2ECWReader((Object)file);
            GridCoverage2D coverage = reader.read(null);
            reader.dispose();
            return new RasterBandData(entityId + "_" + bandName, coverage, (GridCoverageReader)reader, 0.0);
        }
        throw new IOException("The file of the '" + productId + "_" + bandName + "' coverage does not exist");
    }

    static {
        AWS_SCENE_RESOURCE_NAMES.put("productInfo", "productInfo.json");
        AWS_SCENE_RESOURCE_NAMES.put("preview", "preview.jpg");
        AWS_SCENE_RESOURCE_NAMES.put("B1", "B01.jp2");
        AWS_SCENE_RESOURCE_NAMES.put("B2", "B02.jp2");
        AWS_SCENE_RESOURCE_NAMES.put("B3", "B03.jp2");
        AWS_SCENE_RESOURCE_NAMES.put("B4", "B04.jp2");
        AWS_SCENE_RESOURCE_NAMES.put("B5", "B05.jp2");
        AWS_SCENE_RESOURCE_NAMES.put("B6", "B06.jp2");
        AWS_SCENE_RESOURCE_NAMES.put("B7", "B07.jp2");
        AWS_SCENE_RESOURCE_NAMES.put("B8", "B08.jp2");
        AWS_SCENE_RESOURCE_NAMES.put("B9", "B09.jp2");
        AWS_SCENE_RESOURCE_NAMES.put("B10", "B10.jp2");
        AWS_SCENE_RESOURCE_NAMES.put("B11", "B11.jp2");
        AWS_SCENE_RESOURCE_NAMES.put("B12", "B12.jp2");
        AWS_SCENE_RESOURCE_NAMES.put("B8A", "B8A.jp2");
        AWS_SCENE_RESOURCE_NAMES.put("TCI", "TCI.jp2");
        AWS_COLLECTION_NAMES.put("SENTINEL2", "Sentinel2");
    }
}

