/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.sentinel2;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.fs.FileUtil;
import org.locationtech.geowave.format.sentinel2.AnalyzeRunner;
import org.locationtech.geowave.format.sentinel2.Sentinel2BasicCommandLineOptions;
import org.locationtech.geowave.format.sentinel2.Sentinel2DownloadCommandLineOptions;
import org.locationtech.geowave.format.sentinel2.Sentinel2ImageryProvider;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadRunner
extends AnalyzeRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadRunner.class);
    private static final String DOWNLOAD_DIRECTORY = "scenes";
    protected Sentinel2DownloadCommandLineOptions downloadOptions;

    public DownloadRunner(Sentinel2BasicCommandLineOptions analyzeOptions, Sentinel2DownloadCommandLineOptions downloadOptions) {
        super(analyzeOptions);
        this.downloadOptions = downloadOptions;
    }

    @Override
    protected void nextScene(SimpleFeature firstBandOfScene, AnalyzeRunner.AnalysisInfo analysisInfo) {
        super.nextScene(firstBandOfScene, analysisInfo);
        String providerName = this.sentinel2Options.providerName();
        String workspaceDir = this.sentinel2Options.getWorkspaceDir();
        boolean overwriteIfExists = this.downloadOptions.isOverwriteIfExists();
        String userIdent = this.downloadOptions.getUserIdent();
        String password = this.downloadOptions.getPassword();
        Sentinel2ImageryProvider provider = Sentinel2ImageryProvider.getProvider(providerName);
        if (provider == null) {
            throw new RuntimeException("Unable to find '" + providerName + "' Sentinel2 provider");
        }
        File sceneDir = DownloadRunner.getSceneDirectory(firstBandOfScene, workspaceDir);
        if (overwriteIfExists) {
            if (sceneDir.exists() && !FileUtil.fullyDelete((File)sceneDir)) {
                LOGGER.warn("Unable to delete dir '" + sceneDir.getAbsolutePath() + "'");
            }
        } else if (sceneDir.exists()) {
            return;
        }
        if (!sceneDir.getParentFile().exists() && !sceneDir.getParentFile().mkdirs()) {
            LOGGER.warn("Unable to create directory '" + sceneDir.getParentFile().getAbsolutePath() + "'");
        }
        try {
            provider.downloadScene(firstBandOfScene, workspaceDir, userIdent, password);
        }
        catch (IOException e) {
            LOGGER.error("Unable to download scene '" + firstBandOfScene.getAttribute("productIdentifier") + "'");
        }
    }

    public static File getSceneDirectory(SimpleFeature scene, String workspaceDirectory) {
        String scenesDir = workspaceDirectory + File.separator + DOWNLOAD_DIRECTORY;
        String productId = (String)scene.getAttribute("productIdentifier");
        return new File(scenesDir + File.separator + productId);
    }

    protected static void cleanDownloadedFiles(SimpleFeature scene, String workspaceDirectory) {
        File sceneDir = DownloadRunner.getSceneDirectory(scene, workspaceDirectory);
        if (sceneDir.isDirectory()) {
            FileUtil.fullyDelete((File)sceneDir);
        }
    }
}

