/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.sentinel2;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang.ArrayUtils;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.FeatureIteratorIterator;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.geowave.format.sentinel2.SceneFeatureIterator;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;

public class BandFeatureIterator
implements SimpleFeatureIterator {
    public static final String BAND_ATTRIBUTE_NAME = "band";
    private Iterator<SimpleFeature> iterator;
    private final SceneFeatureIterator sceneIterator;

    public static SimpleFeatureTypeBuilder defaultBandFeatureTypeBuilder(String typeName) throws NoSuchAuthorityCodeException, FactoryException {
        SimpleFeatureTypeBuilder sceneBuilder = SceneFeatureIterator.defaultSceneFeatureTypeBuilder(typeName);
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.init(sceneBuilder.buildFeatureType());
        typeBuilder.setName(typeName);
        typeBuilder.setDefaultGeometry("shape");
        typeBuilder.minOccurs(1).maxOccurs(1).nillable(false).add(BAND_ATTRIBUTE_NAME, String.class);
        return typeBuilder;
    }

    public BandFeatureIterator(String providerName, String collection, String platform, String location, Date startDate, Date endDate, int orbitNumber, int relativeOrbitNumber, Filter cqlFilter, String workspaceDir) throws MalformedURLException, IOException, NoSuchAuthorityCodeException, FactoryException, GeneralSecurityException {
        this(new SceneFeatureIterator(providerName, collection, platform, location, startDate, endDate, orbitNumber, relativeOrbitNumber, cqlFilter, workspaceDir), cqlFilter);
    }

    public BandFeatureIterator(SceneFeatureIterator sceneIterator, Filter cqlFilter) throws NoSuchAuthorityCodeException, FactoryException {
        this.sceneIterator = sceneIterator;
        this.init(cqlFilter);
    }

    private void init(Filter cqlFilter) throws NoSuchAuthorityCodeException, FactoryException {
        Object[] attributes;
        SimpleFeatureTypeBuilder typeBuilder = this.sceneIterator.getProvider().bandFeatureTypeBuilder();
        SimpleFeatureType bandType = typeBuilder.buildFeatureType();
        Object featureIterator = new FeatureIteratorIterator((FeatureIterator)this.sceneIterator);
        featureIterator = Iterators.concat((Iterator)Iterators.transform((Iterator)featureIterator, (Function)new SceneToBandFeatureTransform(bandType)));
        if (cqlFilter != null && !cqlFilter.equals(Filter.INCLUDE) && ArrayUtils.contains((Object[])(attributes = DataUtilities.attributeNames((Filter)cqlFilter, (SimpleFeatureType)bandType)), (Object)BAND_ATTRIBUTE_NAME)) {
            featureIterator = Iterators.filter((Iterator)featureIterator, (Predicate)new SceneFeatureIterator.CqlFilterPredicate(cqlFilter));
        }
        this.iterator = featureIterator;
    }

    public void close() {
        this.sceneIterator.close();
    }

    public boolean hasNext() {
        if (this.iterator != null) {
            return this.iterator.hasNext();
        }
        return false;
    }

    public SimpleFeature next() throws NoSuchElementException {
        if (this.iterator != null) {
            return this.iterator.next();
        }
        return null;
    }

    private static class SceneToBandFeatureTransform
    implements Function<SimpleFeature, Iterator<SimpleFeature>> {
        private final SimpleFeatureBuilder featureBuilder;

        public SceneToBandFeatureTransform(SimpleFeatureType type) {
            this.featureBuilder = new SimpleFeatureBuilder(type);
        }

        public Iterator<SimpleFeature> apply(SimpleFeature scene) {
            if (scene == null) {
                return Collections.emptyIterator();
            }
            String entityId = scene.getID();
            ArrayList<SimpleFeature> bands = new ArrayList<SimpleFeature>();
            for (String bandId : scene.getAttribute("bands").toString().split(";")) {
                SimpleFeature band = this.featureBuilder.buildFeature(entityId + "_" + bandId);
                for (Property property : scene.getProperties()) {
                    band.setAttribute(property.getName(), property.getValue());
                }
                band.setAttribute(BandFeatureIterator.BAND_ATTRIBUTE_NAME, (Object)bandId);
                bands.add(band);
            }
            return bands.iterator();
        }
    }
}

