/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.sentinel2;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.converters.IntegerConverter;

public class Sentinel2RasterIngestCommandLineOptions {
    @Parameter(names={"--histogram"}, description="An option to store the histogram of the values of the coverage so that histogram equalization will be performed.")
    private boolean createHistogram = false;
    @Parameter(names={"--pyramid"}, description="An option to store an image pyramid for the coverage.")
    private boolean createPyramid = false;
    @Parameter(names={"--retainimages"}, description="An option to keep the images that are ingested in the local workspace directory.  By default it will delete the local file after it is ingested successfully.")
    private boolean retainImages = false;
    @Parameter(names={"--tilesize"}, description="The option to set the pixel size for each tile stored in GeoWave.  The default is 256.")
    private int tileSize = 512;
    @Parameter(names={"--coverage"}, description="The name to give to each unique coverage.  Freemarker templating can be used for variable substitution based on the same attributes used for filtering.  The default coverage name is '${entityId}_${band}'.  If ${band} is unused in the coverage name, all bands will be merged together into the same coverage.")
    private String coverageName = "${entityId}_${band}";
    @Parameter(names={"--converter"}, description="Prior to ingesting an image, this converter will be used to massage the data.  The default is not to convert the data.")
    private String coverageConverter;
    @Parameter(names={"--subsample"}, description="Subsample the image prior to ingest by the scale factor provided.  The scale factor should be an integer value greater than 1.", converter=IntegerConverter.class)
    private int scale = 1;
    @Parameter(names={"--crop"}, description="Use the spatial constraint provided in CQL to crop the image.  If no spatial constraint is provided, this will not have an effect.")
    private boolean cropToSpatialConstraint;
    @Parameter(names={"--skipMerge"}, description="By default the ingest will automerge overlapping tiles as a post-processing optimization step for efficient retrieval, but this will skip the merge process.")
    private boolean skipMerge;

    public boolean isCreateHistogram() {
        return this.createHistogram;
    }

    public boolean isCreatePyramid() {
        return this.createPyramid;
    }

    public boolean isRetainImages() {
        return this.retainImages;
    }

    public String getCoverageName() {
        return this.coverageName;
    }

    public String getCoverageConverter() {
        return this.coverageConverter;
    }

    public boolean isCoveragePerBand() {
        return this.coverageName.contains("${band}");
    }

    public int getTileSize() {
        return this.tileSize;
    }

    public boolean isSubsample() {
        return this.scale > 1;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isCropToSpatialConstraint() {
        return this.cropToSpatialConstraint;
    }

    public void setCreateHistogram(boolean createHistogram) {
        this.createHistogram = createHistogram;
    }

    public void setCreatePyramid(boolean createPyramid) {
        this.createPyramid = createPyramid;
    }

    public void setRetainImages(boolean retainImages) {
        this.retainImages = retainImages;
    }

    public void setTileSize(int tileSize) {
        this.tileSize = tileSize;
    }

    public void setCoverageName(String coverageName) {
        this.coverageName = coverageName;
    }

    public void setCoverageConverter(String coverageConverter) {
        this.coverageConverter = coverageConverter;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void setCropToSpatialConstraint(boolean cropToSpatialConstraint) {
        this.cropToSpatialConstraint = cropToSpatialConstraint;
    }

    public boolean isSkipMerge() {
        return this.skipMerge;
    }

    public void setSkipMerge(boolean skipMerge) {
        this.skipMerge = skipMerge;
    }
}

