/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.sentinel2;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import it.geosolutions.jaiext.JAIExt;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.Command;
import org.locationtech.geowave.core.cli.api.DefaultOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.format.sentinel2.RasterIngestRunner;
import org.locationtech.geowave.format.sentinel2.Sentinel2BasicCommandLineOptions;
import org.locationtech.geowave.format.sentinel2.Sentinel2DownloadCommandLineOptions;
import org.locationtech.geowave.format.sentinel2.Sentinel2RasterIngestCommandLineOptions;
import org.locationtech.geowave.format.sentinel2.Sentinel2Section;

@GeowaveOperation(name={"ingestraster"}, parentOperation=Sentinel2Section.class)
@Parameters(commandDescription="Ingest routine for locally downloading Sentinel2 imagery and ingesting it into GeoWave")
public class Sentinel2IngestRasterCommand
extends DefaultOperation
implements Command {
    @Parameter(description="<store name> <comma delimited index list>")
    private List<String> parameters = new ArrayList<String>();
    @ParametersDelegate
    protected Sentinel2BasicCommandLineOptions analyzeOptions = new Sentinel2BasicCommandLineOptions();
    @ParametersDelegate
    protected Sentinel2DownloadCommandLineOptions downloadOptions = new Sentinel2DownloadCommandLineOptions();
    @ParametersDelegate
    protected Sentinel2RasterIngestCommandLineOptions ingestOptions = new Sentinel2RasterIngestCommandLineOptions();

    public void execute(OperationParams params) throws Exception {
        JAIExt.initJAIEXT();
        RasterIngestRunner runner = new RasterIngestRunner(this.analyzeOptions, this.downloadOptions, this.ingestOptions, this.parameters);
        runner.runInternal(params);
    }
}

