/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.sentinel2;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import it.geosolutions.jaiext.JAIExt;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.Command;
import org.locationtech.geowave.core.cli.api.DefaultOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.format.sentinel2.IngestRunner;
import org.locationtech.geowave.format.sentinel2.Sentinel2BasicCommandLineOptions;
import org.locationtech.geowave.format.sentinel2.Sentinel2DownloadCommandLineOptions;
import org.locationtech.geowave.format.sentinel2.Sentinel2RasterIngestCommandLineOptions;
import org.locationtech.geowave.format.sentinel2.Sentinel2Section;
import org.locationtech.geowave.format.sentinel2.VectorOverrideCommandLineOptions;

@GeowaveOperation(name={"ingest"}, parentOperation=Sentinel2Section.class)
@Parameters(commandDescription="Ingest routine for locally downloading Sentinel2 imagery and ingesting it into GeoWave's raster store and in parallel ingesting the scene metadata into GeoWave's vector store.  These two stores can actually be the same or they can be different.")
public class Sentinel2IngestCommand
extends DefaultOperation
implements Command {
    @Parameter(description="<store name> <comma delimited index list>")
    private List<String> parameters = new ArrayList<String>();
    @ParametersDelegate
    protected Sentinel2BasicCommandLineOptions analyzeOptions = new Sentinel2BasicCommandLineOptions();
    @ParametersDelegate
    protected Sentinel2DownloadCommandLineOptions downloadOptions = new Sentinel2DownloadCommandLineOptions();
    @ParametersDelegate
    protected Sentinel2RasterIngestCommandLineOptions ingestOptions = new Sentinel2RasterIngestCommandLineOptions();
    @ParametersDelegate
    protected VectorOverrideCommandLineOptions vectorOverrideOptions = new VectorOverrideCommandLineOptions();

    public void execute(OperationParams params) throws Exception {
        JAIExt.initJAIEXT();
        IngestRunner runner = new IngestRunner(this.analyzeOptions, this.downloadOptions, this.ingestOptions, this.vectorOverrideOptions, this.parameters);
        runner.runInternal(params);
    }
}

