/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.sentinel2;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.internal.Console;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import it.geosolutions.jaiext.range.RangeFactory;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.AbstractOperation;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.processing.operation.BandMerge;
import org.geotools.coverage.processing.operation.Crop;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.geowave.adapter.raster.RasterUtils;
import org.locationtech.geowave.adapter.raster.adapter.RasterDataAdapter;
import org.locationtech.geowave.adapter.raster.adapter.merge.RasterTileMergeStrategy;
import org.locationtech.geowave.adapter.raster.adapter.merge.nodata.NoDataMergeStrategy;
import org.locationtech.geowave.adapter.raster.plugin.GeoWaveGTRasterFormat;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.core.geotime.util.ExtractGeometryFilterVisitor;
import org.locationtech.geowave.core.geotime.util.ExtractGeometryFilterVisitorResult;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.index.SPIServiceRegistry;
import org.locationtech.geowave.core.store.api.DataStore;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.api.Writer;
import org.locationtech.geowave.core.store.cli.CLIUtils;
import org.locationtech.geowave.core.store.cli.store.DataStorePluginOptions;
import org.locationtech.geowave.core.store.index.IndexStore;
import org.locationtech.geowave.core.store.util.DataStoreUtils;
import org.locationtech.geowave.format.sentinel2.AnalyzeRunner;
import org.locationtech.geowave.format.sentinel2.DownloadRunner;
import org.locationtech.geowave.format.sentinel2.RasterBandData;
import org.locationtech.geowave.format.sentinel2.Sentinel2BandConverterSpi;
import org.locationtech.geowave.format.sentinel2.Sentinel2BasicCommandLineOptions;
import org.locationtech.geowave.format.sentinel2.Sentinel2DownloadCommandLineOptions;
import org.locationtech.geowave.format.sentinel2.Sentinel2ImageryProvider;
import org.locationtech.geowave.format.sentinel2.Sentinel2RasterIngestCommandLineOptions;
import org.locationtech.jts.geom.Geometry;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

public class RasterIngestRunner
extends DownloadRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(RasterIngestRunner.class);
    private static Map<String, Sentinel2BandConverterSpi> registeredBandConverters = null;
    protected final List<String> parameters;
    protected Sentinel2RasterIngestCommandLineOptions ingestOptions;
    protected List<SimpleFeature> lastSceneBands = new ArrayList<SimpleFeature>();
    protected SimpleFeature lastScene = null;
    protected Template coverageNameTemplate;
    protected final Map<String, Writer<?>> writerCache = new HashMap();
    protected String[] bandsIngested;
    protected DataStore store = null;
    protected DataStorePluginOptions dataStorePluginOptions = null;
    protected Index[] indices = null;
    protected Sentinel2ImageryProvider provider;

    public RasterIngestRunner(Sentinel2BasicCommandLineOptions analyzeOptions, Sentinel2DownloadCommandLineOptions downloadOptions, Sentinel2RasterIngestCommandLineOptions ingestOptions, List<String> parameters) {
        super(analyzeOptions, downloadOptions);
        this.ingestOptions = ingestOptions;
        this.parameters = parameters;
    }

    protected void processParameters(OperationParams params) throws Exception {
        if (this.parameters.size() != 2) {
            throw new ParameterException("Requires arguments: <store name> <comma delimited index list>");
        }
        String providerName = this.sentinel2Options.providerName();
        String inputStoreName = this.parameters.get(0);
        String indexList = this.parameters.get(1);
        this.provider = Sentinel2ImageryProvider.getProvider(providerName);
        if (this.provider == null) {
            throw new RuntimeException("Unable to find '" + providerName + "' Sentinel2 provider");
        }
        File configFile = (File)params.getContext().get("properties-file");
        this.dataStorePluginOptions = CLIUtils.loadStore((String)inputStoreName, (File)configFile, (Console)new JCommander().getConsole());
        this.store = this.dataStorePluginOptions.createDataStore();
        this.indices = DataStoreUtils.loadIndices((IndexStore)this.dataStorePluginOptions.createIndexStore(), (String)indexList).toArray(new Index[0]);
        this.coverageNameTemplate = new Template("name", (Reader)new StringReader(this.ingestOptions.getCoverageName()), new Configuration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runInternal(OperationParams params) throws Exception {
        try {
            this.processParameters(params);
            super.runInternal(params);
        }
        finally {
            for (Writer<?> writer : this.writerCache.values()) {
                if (writer == null) continue;
                writer.close();
            }
        }
    }

    protected RasterBandData getBandData(SimpleFeature band) throws IOException, TemplateException {
        Sentinel2BandConverterSpi converter;
        HashMap<String, Object> model = new HashMap<String, Object>();
        SimpleFeatureType type = band.getFeatureType();
        for (AttributeDescriptor descriptor : type.getAttributeDescriptors()) {
            String name = descriptor.getLocalName();
            Object value = band.getAttribute(name);
            if (value == null) continue;
            model.put(name, value);
        }
        String coverageName = FreeMarkerTemplateUtils.processTemplateIntoString((Template)this.coverageNameTemplate, model);
        RasterBandData bandData = this.provider.getCoverage(band, this.sentinel2Options.getWorkspaceDir());
        GridCoverage2D coverage = bandData.coverage;
        GridCoverageReader reader = bandData.reader;
        double nodataValue = bandData.nodataValue;
        if (this.ingestOptions.getCoverageConverter() != null && !this.ingestOptions.getCoverageConverter().trim().isEmpty() && (converter = this.getConverter(this.ingestOptions.getCoverageConverter())) != null) {
            coverage = converter.convert(coverageName, coverage, band);
        }
        if (this.ingestOptions.isSubsample()) {
            coverage = (GridCoverage2D)RasterUtils.getCoverageOperations().filteredSubsample((GridCoverage)coverage, this.ingestOptions.getScale(), this.ingestOptions.getScale(), null);
        }
        if (this.ingestOptions.isCropToSpatialConstraint()) {
            boolean cropped = false;
            Filter filter = this.sentinel2Options.getCqlFilter();
            if (filter != null) {
                ExtractGeometryFilterVisitorResult geometryAndCompareOp = ExtractGeometryFilterVisitor.getConstraints((Filter)filter, (CoordinateReferenceSystem)GeoWaveGTRasterFormat.DEFAULT_CRS, (String)"shape");
                Geometry geometry = geometryAndCompareOp.getGeometry();
                if (geometry != null) {
                    Geometry sceneShape = (Geometry)band.getAttribute("shape");
                    if (geometry.contains(sceneShape)) {
                        cropped = true;
                    } else {
                        geometry = geometry.intersection(sceneShape);
                        CoverageProcessor processor = CoverageProcessor.getInstance();
                        AbstractOperation op = (AbstractOperation)processor.getOperation("CoverageCrop");
                        ParameterValueGroup params = op.getParameters();
                        params.parameter("Source").setValue((Object)coverage);
                        try {
                            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)GeometryUtils.getDefaultCRS(), (CoordinateReferenceSystem)coverage.getCoordinateReferenceSystem(), (boolean)true);
                            params.parameter(Crop.CROP_ROI.getName().getCode()).setValue((Object)JTS.transform((Geometry)geometry, (MathTransform)transform));
                            params.parameter(Crop.NODATA.getName().getCode()).setValue((Object)RangeFactory.create((double)nodataValue, (double)nodataValue));
                            params.parameter(Crop.DEST_NODATA.getName().getCode()).setValue((Object)new double[]{nodataValue});
                            coverage = (GridCoverage2D)op.doOperation(params, null);
                            cropped = true;
                        }
                        catch (MismatchedDimensionException | InvalidParameterValueException | ParameterNotFoundException | FactoryException | TransformException e) {
                            LOGGER.warn("Unable to crop image", e);
                        }
                    }
                }
                if (!cropped) {
                    LOGGER.warn("Option to crop spatially was set but no spatial constraints were provided in CQL expression");
                }
            }
        }
        return new RasterBandData(coverageName, coverage, reader, nodataValue);
    }

    @Override
    protected void nextBand(SimpleFeature band, AnalyzeRunner.AnalysisInfo analysisInfo) {
        super.nextBand(band, analysisInfo);
        if (this.ingestOptions.isCoveragePerBand()) {
            try {
                RasterBandData bandData = this.getBandData(band);
                GridCoverage2D coverage = bandData.coverage;
                String coverageName = bandData.name;
                GridCoverageReader reader = bandData.reader;
                double nodataValue = bandData.nodataValue;
                Writer writer = this.writerCache.get(coverageName);
                GridCoverage2D nextCov = coverage;
                if (writer == null) {
                    HashMap<String, String> metadata = new HashMap<String, String>();
                    String[] metadataNames = reader.getMetadataNames();
                    if (metadataNames != null && metadataNames.length > 0) {
                        for (String metadataName : metadataNames) {
                            metadata.put(metadataName, reader.getMetadataValue(metadataName));
                        }
                    }
                    RasterDataAdapter adapter = new RasterDataAdapter(coverageName, metadata, nextCov, this.ingestOptions.getTileSize(), this.ingestOptions.isCreatePyramid(), this.ingestOptions.isCreateHistogram(), (double[][])new double[][]{{nodataValue}}, (RasterTileMergeStrategy)new NoDataMergeStrategy());
                    this.store.addType((DataTypeAdapter)adapter, this.indices);
                    writer = this.store.createWriter(adapter.getTypeName());
                    this.writerCache.put(coverageName, writer);
                }
                writer.write((Object)nextCov);
            }
            catch (TemplateException | IOException e) {
                LOGGER.error("Unable to ingest band " + band.getID() + " because coverage name cannot be resolved from template", e);
            }
        } else {
            this.lastSceneBands.add(band);
        }
    }

    @Override
    protected void lastSceneComplete(AnalyzeRunner.AnalysisInfo analysisInfo) {
        this.processPreviousScene();
        super.lastSceneComplete(analysisInfo);
        if (!this.ingestOptions.isSkipMerge()) {
            System.out.println("Merging overlapping tiles...");
            for (Index index : this.indices) {
                if (this.dataStorePluginOptions.createDataStoreOperations().mergeData(index, this.dataStorePluginOptions.createAdapterStore(), this.dataStorePluginOptions.createInternalAdapterStore(), this.dataStorePluginOptions.createAdapterIndexMappingStore(), Integer.valueOf(this.dataStorePluginOptions.getFactoryOptions().getStoreOptions().getMaxRangeDecomposition()))) {
                    System.out.println("Successfully merged overlapping tiles within index '" + index.getName() + "'");
                    continue;
                }
                System.err.println("Unable to merge overlapping landsat8 tiles in index '" + index.getName() + "'");
            }
        }
        if (this.lastScene != null && !this.ingestOptions.isRetainImages()) {
            DownloadRunner.cleanDownloadedFiles(this.lastScene, this.sentinel2Options.getWorkspaceDir());
        }
        this.lastScene = null;
    }

    @Override
    protected void nextScene(SimpleFeature firstBandOfScene, AnalyzeRunner.AnalysisInfo analysisInfo) {
        this.processPreviousScene();
        super.nextScene(firstBandOfScene, analysisInfo);
        if (this.lastScene != null && !this.ingestOptions.isRetainImages()) {
            DownloadRunner.cleanDownloadedFiles(this.lastScene, this.sentinel2Options.getWorkspaceDir());
        }
        this.lastScene = firstBandOfScene;
    }

    protected void processPreviousScene() {
        if (!this.ingestOptions.isCoveragePerBand() && !this.lastSceneBands.isEmpty()) {
            Writer writer;
            GridCoverage2D mergedCoverage;
            TreeMap<String, RasterBandData> sceneData = new TreeMap<String, RasterBandData>();
            String coverageName = null;
            for (SimpleFeature band : this.lastSceneBands) {
                try {
                    RasterBandData bandData = this.getBandData(band);
                    if (coverageName == null) {
                        coverageName = bandData.name;
                    } else if (!coverageName.equals(bandData.name)) {
                        LOGGER.warn("Unable to use band data as the band coverage name '" + bandData.name + "' is unexpectedly different from default name '" + coverageName + "'");
                    }
                    String bandName = band.getAttribute("band").toString();
                    sceneData.put(bandName, bandData);
                }
                catch (TemplateException | IOException e) {
                    LOGGER.warn("Unable to read band data", e);
                }
            }
            if (coverageName == null) {
                LOGGER.warn("No valid bands found for scene");
                this.lastSceneBands.clear();
                return;
            }
            if (sceneData.size() == 1) {
                mergedCoverage = ((RasterBandData)sceneData.firstEntry().getValue()).coverage;
            } else {
                CoverageProcessor processor = CoverageProcessor.getInstance();
                AbstractOperation op = (AbstractOperation)processor.getOperation("BandMerge");
                ParameterValueGroup params = op.getParameters();
                ArrayList<GridCoverage2D> sources = new ArrayList<GridCoverage2D>();
                for (RasterBandData bandData : sceneData.values()) {
                    sources.add(bandData.coverage);
                }
                params.parameter("Sources").setValue(sources);
                params.parameter("transform_choice").setValue((Object)BandMerge.TransformList.FIRST.toString());
                mergedCoverage = (GridCoverage2D)op.doOperation(params, null);
            }
            Object[] thisSceneBands = sceneData.keySet().toArray(new String[0]);
            if (this.bandsIngested == null) {
                HashMap<String, String> metadata = new HashMap<String, String>();
                double[][] noDataValues = new double[sceneData.size()][];
                int b = 0;
                for (RasterBandData bandData : sceneData.values()) {
                    try {
                        String[] metadataNames = bandData.reader.getMetadataNames();
                        if (metadataNames != null && metadataNames.length > 0) {
                            for (String metadataName : metadataNames) {
                                metadata.put(metadataName, bandData.reader.getMetadataValue(metadataName));
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn("Unable to get metadata for coverage '" + coverageName + "'.", (Throwable)e);
                    }
                    noDataValues[b++] = new double[]{bandData.nodataValue};
                }
                RasterDataAdapter adapter = new RasterDataAdapter(coverageName, metadata, mergedCoverage, this.ingestOptions.getTileSize(), this.ingestOptions.isCreatePyramid(), this.ingestOptions.isCreateHistogram(), (double[][])noDataValues, (RasterTileMergeStrategy)new NoDataMergeStrategy());
                this.store.addType((DataTypeAdapter)adapter, this.indices);
                writer = this.store.createWriter(adapter.getTypeName());
                this.writerCache.put(coverageName, writer);
                this.bandsIngested = thisSceneBands;
            } else {
                if (!Arrays.equals(this.bandsIngested, thisSceneBands)) {
                    LOGGER.warn("The bands in this scene ('" + Arrays.toString(thisSceneBands) + "') differ from the previous scene ('" + Arrays.toString(this.bandsIngested) + "').  To merge bands all scenes must use the same bands.  Skipping scene'" + this.lastSceneBands.get(0).getAttribute("entityId") + "'.");
                    this.lastSceneBands.clear();
                    return;
                }
                writer = this.writerCache.get(coverageName);
                if (writer == null) {
                    LOGGER.warn("Unable to find writer for coverage '" + coverageName + "'.  Skipping scene'" + this.lastSceneBands.get(0).getAttribute("entityId") + "'.");
                    this.lastSceneBands.clear();
                    return;
                }
            }
            writer.write((Object)mergedCoverage);
            this.lastSceneBands.clear();
        }
    }

    public Sentinel2BandConverterSpi getConverter(String converterName) {
        Sentinel2BandConverterSpi converter = this.getRegisteredConverters().get(converterName);
        if (converter == null) {
            LOGGER.warn("no Sentinel2 converter registered with name '" + converterName + "'");
        }
        return converter;
    }

    private synchronized Map<String, Sentinel2BandConverterSpi> getRegisteredConverters() {
        if (registeredBandConverters == null) {
            registeredBandConverters = new HashMap<String, Sentinel2BandConverterSpi>();
            Iterator spiIter = new SPIServiceRegistry(RasterIngestRunner.class).load(Sentinel2BandConverterSpi.class);
            while (spiIter.hasNext()) {
                Sentinel2BandConverterSpi converter = (Sentinel2BandConverterSpi)spiIter.next();
                registeredBandConverters.put(converter.getName(), converter);
            }
        }
        return registeredBandConverters;
    }
}

