/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.sentinel2;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.format.sentinel2.BandFeatureIterator;
import org.locationtech.geowave.format.sentinel2.Sentinel2BasicCommandLineOptions;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzeRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyzeRunner.class);
    protected Sentinel2BasicCommandLineOptions sentinel2Options = new Sentinel2BasicCommandLineOptions();

    public AnalyzeRunner(Sentinel2BasicCommandLineOptions options) {
        this.sentinel2Options = options;
    }

    protected void runInternal(OperationParams params) throws Exception {
        try (BandFeatureIterator bands = new BandFeatureIterator(this.sentinel2Options.providerName(), this.sentinel2Options.collection(), this.sentinel2Options.platform(), this.sentinel2Options.location(), this.sentinel2Options.startDate(), this.sentinel2Options.endDate(), this.sentinel2Options.orbitNumber(), this.sentinel2Options.relativeOrbitNumber(), this.sentinel2Options.getCqlFilter(), this.sentinel2Options.getWorkspaceDir());){
            AnalysisInfo info = new AnalysisInfo();
            String prevEntityId = null;
            while (bands.hasNext()) {
                SimpleFeature band = bands.next();
                String entityId = (String)band.getAttribute("entityId");
                if (prevEntityId == null || !prevEntityId.equals(entityId)) {
                    prevEntityId = entityId;
                    this.nextScene(band, info);
                }
                this.nextBand(band, info);
            }
            this.lastSceneComplete(info);
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    protected void nextScene(SimpleFeature firstBandOfScene, AnalysisInfo analysisInfo) {
        analysisInfo.nextScene(firstBandOfScene);
    }

    protected void nextBand(SimpleFeature band, AnalysisInfo analysisInfo) {
        analysisInfo.addBandInfo(band);
    }

    protected void lastSceneComplete(AnalysisInfo analysisInfo) {
        analysisInfo.printSceneInfo();
        analysisInfo.printTotals();
    }

    protected static class AnalysisInfo {
        private final TreeMap<String, SimpleFeature> entityBandIdToSimpleFeatureMap = new TreeMap();
        private int sceneCount = 0;
        private double minLat = Double.MAX_VALUE;
        private double minLon = Double.MAX_VALUE;
        private double maxLat = -1.7976931348623157E308;
        private double maxLon = -1.7976931348623157E308;
        private long startDate = Long.MAX_VALUE;
        private long endDate = 0L;
        private float totalCloudCover = 0.0f;
        private int minCloudCover = Integer.MAX_VALUE;
        private int maxCloudCover = -2147483647;
        private final Map<String, Integer> processingLevelCounts = new HashMap<String, Integer>();

        protected AnalysisInfo() {
        }

        private void nextScene(SimpleFeature currentBand) {
            this.printSceneInfo();
            ++this.sceneCount;
            this.entityBandIdToSimpleFeatureMap.clear();
            Envelope env = ((Geometry)currentBand.getDefaultGeometry()).getEnvelopeInternal();
            Date date = (Date)currentBand.getAttribute("startDate");
            String processingLevel = (String)currentBand.getAttribute("processingLevel");
            int cloudCover = (Integer)currentBand.getAttribute("cloudCover");
            this.minLat = Math.min(this.minLat, env.getMinY());
            this.maxLat = Math.max(this.maxLat, env.getMaxY());
            this.minLon = Math.min(this.minLon, env.getMinX());
            this.maxLon = Math.max(this.maxLon, env.getMaxX());
            this.startDate = Math.min(this.startDate, date.getTime());
            this.endDate = Math.max(this.endDate, date.getTime());
            Integer count = this.processingLevelCounts.get(processingLevel);
            if (count == null) {
                count = 0;
            }
            count = count + 1;
            this.processingLevelCounts.put(processingLevel, count);
            this.minCloudCover = Math.min(this.minCloudCover, cloudCover);
            this.maxCloudCover = Math.max(this.maxCloudCover, cloudCover);
            this.totalCloudCover += (float)cloudCover;
        }

        private void addBandInfo(SimpleFeature band) {
            String bandName = (String)band.getAttribute("band");
            this.entityBandIdToSimpleFeatureMap.put(bandName, band);
        }

        private void printSceneInfo() {
            if (this.sceneCount > 0) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                boolean first = true;
                for (Map.Entry<String, SimpleFeature> entry : this.entityBandIdToSimpleFeatureMap.entrySet()) {
                    String bandId = entry.getKey();
                    SimpleFeature feature = entry.getValue();
                    if (first) {
                        if (feature == null) {
                            throw new RuntimeException("feature is null");
                        }
                        System.out.println("\n<--   " + feature.getAttribute("productIdentifier") + "   -->");
                        System.out.println("Provider Name: " + feature.getAttribute("provider"));
                        System.out.println("Acquisition Date: " + sdf.format(feature.getAttribute("startDate")));
                        System.out.println("Location: " + feature.getAttribute("location"));
                        System.out.println("Product Identifier: " + feature.getAttribute("productIdentifier"));
                        System.out.println("Product Type: " + feature.getAttribute("productType"));
                        System.out.println("Collection: " + feature.getAttribute("collection"));
                        System.out.println("Platform: " + feature.getAttribute("platform"));
                        System.out.println("Processing Level: " + feature.getAttribute("processingLevel"));
                        System.out.println("Quicklook: " + feature.getAttribute("quicklook"));
                        System.out.println("Thumbnail: " + feature.getAttribute("thumbnail"));
                        System.out.println("Cloud Cover: " + feature.getAttribute("cloudCover"));
                        System.out.println("Snow Cover: " + feature.getAttribute("snowCover"));
                        System.out.println("Water Cover: " + feature.getAttribute("waterCover"));
                        System.out.println("Orbit Number: " + feature.getAttribute("orbitNumber"));
                        System.out.println("Relative Orbit Number: " + feature.getAttribute("relativeOrbitNumber"));
                        first = false;
                    }
                    System.out.println("Band " + bandId);
                }
            }
        }

        private void printTotals() {
            System.out.println("\n<--   Totals   -->");
            System.out.println("Total Scenes: " + this.sceneCount);
            if (this.sceneCount > 0) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                System.out.println("Date Range: [" + sdf.format(new Date(this.startDate)) + ", " + sdf.format(new Date(this.endDate)) + "]");
                System.out.println("Cloud Cover Range: [" + this.minCloudCover + ", " + this.maxCloudCover + "]");
                System.out.println("Average Cloud Cover: " + this.totalCloudCover / (float)this.sceneCount);
                System.out.println("Latitude Range: [" + this.minLat + ", " + this.maxLat + "]");
                System.out.println("Longitude Range: [" + this.minLon + ", " + this.maxLon + "]");
                StringBuffer strBuf = new StringBuffer("Processing Levels: ");
                boolean includeSceneCount = false;
                boolean first = true;
                if (this.processingLevelCounts.size() > 1) {
                    includeSceneCount = true;
                }
                for (Map.Entry<String, Integer> entry : this.processingLevelCounts.entrySet()) {
                    if (!first) {
                        strBuf.append(", ");
                    } else {
                        first = false;
                    }
                    strBuf.append(entry.getKey());
                    if (!includeSceneCount) continue;
                    strBuf.append(" (" + entry.getValue() + " scenes)");
                }
                System.out.println(strBuf.toString());
            }
        }
    }
}

