/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.sentinel2.theia;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import javax.net.ssl.HttpsURLConnection;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.geowave.adapter.raster.plugin.gdal.GDALGeoTiffReader;
import org.locationtech.geowave.adapter.raster.util.ZipUtils;
import org.locationtech.geowave.format.sentinel2.BandFeatureIterator;
import org.locationtech.geowave.format.sentinel2.DownloadRunner;
import org.locationtech.geowave.format.sentinel2.RasterBandData;
import org.locationtech.geowave.format.sentinel2.SceneFeatureIterator;
import org.locationtech.geowave.format.sentinel2.Sentinel2ImageryProvider;
import org.locationtech.jts.geom.Envelope;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TheiaImageryProvider
extends Sentinel2ImageryProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TheiaImageryProvider.class);
    private static final String SCENES_TYPE_NAME = "theia-sentinel2-scene";
    private static final String BANDS_TYPE_NAME = "theia-sentinel2-band";
    private static final double NO_DATA_VALUE = 0.0;
    private static final String SCENES_SEARCH_URL = "https://theia.cnes.fr/atdistrib/resto2/api/collections/%s/search.json?";
    private static final String AUNTHENTICATION_URL = "https://theia.cnes.fr/atdistrib/services/authenticate/";
    private static final String DOWNLOAD_URL = "https://theia.cnes.fr/atdistrib/resto2/collections/%s/%s/download/?issuerId=theia";
    private static final int DOWNLOAD_RETRY = 5;

    @Override
    public String providerName() {
        return "THEIA";
    }

    @Override
    public String description() {
        return "Sentinel2 provider for the Theia repository (https://theia.cnes.fr)";
    }

    @Override
    public String[] collections() {
        return new String[]{"SENTINEL2"};
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public SimpleFeatureTypeBuilder sceneFeatureTypeBuilder() throws NoSuchAuthorityCodeException, FactoryException {
        return SceneFeatureIterator.defaultSceneFeatureTypeBuilder(SCENES_TYPE_NAME);
    }

    @Override
    public SimpleFeatureTypeBuilder bandFeatureTypeBuilder() throws NoSuchAuthorityCodeException, FactoryException {
        return BandFeatureIterator.defaultBandFeatureTypeBuilder(BANDS_TYPE_NAME);
    }

    @Override
    public Iterator<SimpleFeature> searchScenes(File scenesDir, String collection, String platform, String location, Envelope envelope, Date startDate, Date endDate, int orbitNumber, int relativeOrbitNumber) throws IOException {
        class TheiaJSONFeatureIterator
        extends Sentinel2ImageryProvider.JSONFeatureIterator {
            public TheiaJSONFeatureIterator(Sentinel2ImageryProvider provider, SimpleFeatureType featureType, Iterator<?> iterator) {
                super(provider, featureType, iterator);
            }

            @Override
            public SimpleFeature next() {
                SimpleFeature feature = super.next();
                JSONObject jsonObject = null;
                if (feature != null && (jsonObject = super.currentObject()) != null) {
                    JSONObject properties = (JSONObject)jsonObject.get("properties");
                    String entityId = jsonObject.getString("id");
                    String collection = properties.getString("collection");
                    String downloadUrl = String.format(TheiaImageryProvider.DOWNLOAD_URL, collection, entityId);
                    feature.setAttribute("sceneDownloadUrl", (Object)downloadUrl);
                }
                return feature;
            }
        }
        TheiaJSONFeatureIterator theiaJSONFeatureIterator;
        InputStream inputStream;
        block14: {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String searchUrl = String.format(SCENES_SEARCH_URL, collection);
            if (platform != null && platform.length() > 0) {
                searchUrl = searchUrl + "platform=" + platform + "&";
            }
            if (location != null && location.length() > 0) {
                searchUrl = searchUrl + "location=" + location + "&";
            }
            if (envelope != null && !envelope.isNull()) {
                searchUrl = searchUrl + String.format(Locale.ENGLISH, "box=%.6f,%.6f,%.6f,%.6f&", envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
            }
            if (startDate != null) {
                searchUrl = searchUrl + "startDate=" + dateFormat.format(startDate) + "&";
            }
            if (endDate != null) {
                searchUrl = searchUrl + "completionDate=" + dateFormat.format(endDate) + "&";
            }
            if (orbitNumber > 0) {
                searchUrl = searchUrl + "orbitNumber=" + orbitNumber + "&";
            }
            if (relativeOrbitNumber > 0) {
                searchUrl = searchUrl + "relativeOrbitNumber=" + relativeOrbitNumber + "&";
            }
            searchUrl = searchUrl.substring(0, searchUrl.length() - 1);
            inputStream = null;
            ByteArrayOutputStream outputStream = null;
            try {
                URL url = new URL(searchUrl);
                HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
                connection.setUseCaches(false);
                connection.setRequestProperty("User-Agent", "Mozilla/5.0");
                connection.setRequestMethod("GET");
                File customCertsFile = new File(scenesDir.getParentFile(), "theia-keystore.crt");
                TheiaImageryProvider.applyCustomCertsFile(connection, customCertsFile);
                inputStream = connection.getInputStream();
                outputStream = new ByteArrayOutputStream();
                IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
                String geoJson = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
                JSONObject response = JSONObject.fromObject((Object)geoJson);
                JSONArray features = response.getJSONArray("features");
                SimpleFeatureTypeBuilder typeBuilder = this.sceneFeatureTypeBuilder();
                SimpleFeatureType type = typeBuilder.buildFeatureType();
                theiaJSONFeatureIterator = new TheiaJSONFeatureIterator(this, type, features.iterator());
                if (outputStream == null) break block14;
            }
            catch (GeneralSecurityException | FactoryException e) {
                try {
                    throw new IOException(e);
                }
                catch (Throwable throwable) {
                    if (outputStream != null) {
                        IOUtils.closeQuietly(outputStream);
                        outputStream = null;
                    }
                    if (inputStream != null) {
                        IOUtils.closeQuietly(inputStream);
                        inputStream = null;
                    }
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)outputStream);
            outputStream = null;
        }
        if (inputStream != null) {
            IOUtils.closeQuietly((InputStream)inputStream);
            inputStream = null;
        }
        return theiaJSONFeatureIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean downloadScene(SimpleFeature scene, String workspaceDir, String userIdent, String password) throws IOException {
        String tokenId;
        InputStream inputStream;
        String entityId;
        String productId;
        String collection;
        block17: {
            String authentication;
            String tokenUrl = AUNTHENTICATION_URL;
            collection = (String)scene.getAttribute("collection");
            productId = (String)scene.getAttribute("productIdentifier");
            entityId = (String)scene.getAttribute("entityId");
            if (userIdent == null || userIdent.length() == 0 || password == null || password.length() == 0) {
                LOGGER.error("Invalid or empty authentication parameters (email and password)");
                return false;
            }
            try {
                authentication = "ident=" + URLEncoder.encode(userIdent, "UTF-8") + "&pass=" + URLEncoder.encode(password, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("Invalid or empty authentication parameters (email and password)" + e.getMessage());
                return false;
            }
            inputStream = null;
            try {
                URL url = new URL(AUNTHENTICATION_URL);
                HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
                connection.setUseCaches(false);
                connection.setRequestProperty("User-Agent", "Mozilla/5.0");
                connection.setRequestMethod("POST");
                connection.setDoOutput(true);
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                connection.setRequestProperty("Content-Length", String.valueOf(authentication.length()));
                File customCertsFile = new File(workspaceDir, "theia-keystore.crt");
                TheiaImageryProvider.applyCustomCertsFile(connection, customCertsFile);
                OutputStream os = connection.getOutputStream();
                os.write(authentication.getBytes("UTF-8"));
                os.flush();
                os.close();
                inputStream = connection.getInputStream();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
                tokenId = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
                IOUtils.closeQuietly((OutputStream)outputStream);
                if (inputStream == null) break block17;
            }
            catch (IOException | GeneralSecurityException e) {
                LOGGER.error("Unable to query a token to download '" + e.getMessage() + "'");
                boolean connection = false;
                return connection;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            inputStream = null;
            break block17;
            finally {
                if (inputStream != null) {
                    IOUtils.closeQuietly(inputStream);
                    inputStream = null;
                }
            }
        }
        if (tokenId.length() == 0) {
            LOGGER.error("Unable to get a token to download. Check your ident and password");
            return false;
        }
        File compressedFile = new File(workspaceDir + File.separator + "scenes" + File.separator + productId + ".zip");
        File productDir = DownloadRunner.getSceneDirectory(scene, workspaceDir);
        String downloadUrl = String.format(DOWNLOAD_URL, collection, entityId);
        int retry = 0;
        boolean success = false;
        while (!success) {
            if (retry >= 5) return success;
            try {
                DefaultClientConfig clientConfig = new DefaultClientConfig();
                Client client = Client.create((ClientConfig)clientConfig);
                ClientResponse response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)client.resource(downloadUrl).accept(new String[]{"application/zip"}).header("User-Agent", (Object)"Mozilla/5.0")).header("Authorization", (Object)("Bearer " + tokenId))).get(ClientResponse.class);
                String displaySize = FileUtils.byteCountToDisplaySize((long)response.getLength());
                System.out.println("\nDownloading file '" + productId + "' (" + displaySize + ")");
                System.out.print("Wait please... ");
                inputStream = response.getEntityInputStream();
                FileOutputStream outputStream = new FileOutputStream(compressedFile);
                TheiaImageryProvider.copyLarge(inputStream, outputStream, response.getLength());
                IOUtils.closeQuietly((OutputStream)outputStream);
                displaySize = FileUtils.byteCountToDisplaySize((long)compressedFile.length());
                System.out.println("File successfully downloaded! (" + displaySize + ")");
                ZipUtils.unZipFile((File)compressedFile, (String)productDir.getAbsolutePath(), (boolean)true);
                System.out.println("File successfully unzipped!");
                if (!compressedFile.delete()) {
                    LOGGER.warn("Unable to delete file '" + compressedFile.getAbsolutePath() + "'");
                }
                success = true;
            }
            catch (IOException e) {
                LOGGER.error("Unable to read file from public '" + downloadUrl + "'; retry round " + ++retry, (Throwable)e);
            }
            finally {
                if (inputStream == null) continue;
                IOUtils.closeQuietly((InputStream)inputStream);
                inputStream = null;
            }
        }
        return success;
    }

    @Override
    public RasterBandData getCoverage(SimpleFeature band, String workspaceDir) throws IOException {
        File sceneDir = DownloadRunner.getSceneDirectory(band, workspaceDir);
        String entityId = (String)band.getAttribute("entityId");
        String productId = (String)band.getAttribute("productIdentifier");
        String bandName = (String)band.getAttribute("band");
        File file = sceneDir;
        String[] fileList = sceneDir.list();
        if (fileList != null) {
            for (String name : fileList) {
                File geotiffFile;
                File temp = new File(file.getAbsolutePath() + File.separatorChar + name);
                if (!temp.isDirectory() || !name.toUpperCase(Locale.ENGLISH).startsWith(productId.toUpperCase(Locale.ENGLISH)) || !(geotiffFile = new File(file.getAbsolutePath() + File.separatorChar + name + File.separatorChar + name + "_FRE_" + bandName + ".tif")).exists()) continue;
                GDALGeoTiffReader reader = new GDALGeoTiffReader((Object)geotiffFile);
                GridCoverage2D coverage = reader.read(null);
                reader.dispose();
                return new RasterBandData(entityId + "_" + bandName, coverage, (GridCoverageReader)reader, 0.0);
            }
        }
        throw new IOException("The file of the '" + productId + "_" + bandName + "' coverage does not exist");
    }
}

