/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.sentinel2;

import com.beust.jcommander.Parameters;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.Command;
import org.locationtech.geowave.core.cli.api.DefaultOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.format.sentinel2.Sentinel2ImageryProvider;
import org.locationtech.geowave.format.sentinel2.Sentinel2Section;

@GeowaveOperation(name={"providers"}, parentOperation=Sentinel2Section.class)
@Parameters(commandDescription="Show info of supported Sentinel2 imagery providers")
public class Sentinel2ImageryProvidersCommand
extends DefaultOperation
implements Command {
    public void execute(OperationParams params) throws Exception {
        System.out.print("Supported Sentinel2 providers:");
        StringBuilder sb = new StringBuilder();
        for (Sentinel2ImageryProvider provider : Sentinel2ImageryProvider.getProviders()) {
            sb.append("\n - ").append(provider.providerName()).append(":").append("\n   - Description: ").append(provider.description()).append("\n   - Collections: ");
            for (String collection : provider.collections()) {
                sb.append(collection).append(", ");
            }
            sb.setLength(sb.length() - 2);
        }
        System.out.println(sb.toString());
        System.out.println();
    }
}

