/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.sentinel2;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import net.sf.json.JSONObject;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geojson.geom.GeometryJSON;
import org.geotools.util.Converters;
import org.locationtech.geowave.adapter.vector.util.DateUtilities;
import org.locationtech.geowave.format.sentinel2.RasterBandData;
import org.locationtech.geowave.format.sentinel2.amazon.AmazonImageryProvider;
import org.locationtech.geowave.format.sentinel2.theia.TheiaImageryProvider;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Sentinel2ImageryProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(Sentinel2ImageryProvider.class);
    protected static final String DOWNLOAD_DIRECTORY = "scenes";
    private static final Class<?>[] PROVIDER_CLASSES = new Class[]{TheiaImageryProvider.class, AmazonImageryProvider.class};
    private static final Map<String, Sentinel2ImageryProvider> PROVIDERS = new HashMap<String, Sentinel2ImageryProvider>();

    public static Sentinel2ImageryProvider[] getProviders() {
        return PROVIDERS.values().toArray(new Sentinel2ImageryProvider[PROVIDERS.size()]);
    }

    public static Sentinel2ImageryProvider getProvider(String providerName) {
        return PROVIDERS.get(providerName.toUpperCase());
    }

    public abstract String providerName();

    public abstract String description();

    public abstract String[] collections();

    public abstract boolean isAvailable();

    public abstract SimpleFeatureTypeBuilder sceneFeatureTypeBuilder() throws NoSuchAuthorityCodeException, FactoryException;

    public abstract SimpleFeatureTypeBuilder bandFeatureTypeBuilder() throws NoSuchAuthorityCodeException, FactoryException;

    public abstract Iterator<SimpleFeature> searchScenes(File var1, String var2, String var3, String var4, Envelope var5, Date var6, Date var7, int var8, int var9) throws IOException;

    public abstract boolean downloadScene(SimpleFeature var1, String var2, String var3, String var4) throws IOException;

    public abstract RasterBandData getCoverage(SimpleFeature var1, String var2) throws IOException;

    protected static boolean applyCustomCertsFile(HttpsURLConnection connection, File customCertsFile) throws GeneralSecurityException, IOException {
        if (customCertsFile.exists()) {
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                BufferedInputStream caInput = new BufferedInputStream(new FileInputStream(customCertsFile));
                Certificate ca = cf.generateCertificate(caInput);
                String keyStoreType = KeyStore.getDefaultType();
                KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                keyStore.load(null, null);
                keyStore.setCertificateEntry("ca", ca);
                String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
                tmf.init(keyStore);
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(null, tmf.getTrustManagers(), null);
                connection.setSSLSocketFactory(context.getSocketFactory());
                return true;
            }
            catch (GeneralSecurityException securityException) {
                LOGGER.error("Unable to use keystore '" + customCertsFile.getAbsolutePath() + "'", (Throwable)securityException);
                throw securityException;
            }
        }
        return false;
    }

    protected static long copyLarge(InputStream input, OutputStream output, int contentLength) throws IOException {
        long count = 0L;
        int n = 0;
        byte[] buffer = new byte[4096];
        int EOF = -1;
        int percentDone = 0;
        int lastPercentDone = -1;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            if (contentLength == -1 || lastPercentDone == (percentDone = (int)(100L * (count += (long)n) / (long)contentLength))) continue;
            lastPercentDone = percentDone;
            if (percentDone % 10 == 0) {
                System.out.print(percentDone + "%");
                continue;
            }
            if (percentDone % 3 != 0) continue;
            System.out.print(".");
        }
        System.out.println();
        return count;
    }

    static {
        for (Class<?> clazz : PROVIDER_CLASSES) {
            try {
                Sentinel2ImageryProvider provider = (Sentinel2ImageryProvider)clazz.newInstance();
                if (!provider.isAvailable()) continue;
                PROVIDERS.put(provider.providerName().toUpperCase(), provider);
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOGGER.error("Unable to create new instance of " + clazz.getName(), (Throwable)e);
            }
        }
    }

    protected static class JSONFeatureIterator
    implements Iterator<SimpleFeature> {
        private final Sentinel2ImageryProvider provider;
        private final SimpleFeatureType featureType;
        private final Iterator<?> iterator;
        private JSONObject currentObject;

        public JSONFeatureIterator(Sentinel2ImageryProvider provider, SimpleFeatureType featureType, Iterator<?> iterator) {
            this.provider = provider;
            this.featureType = featureType;
            this.iterator = iterator;
        }

        public JSONObject currentObject() {
            return this.currentObject;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public SimpleFeature next() {
            JSONObject jsonObject = this.currentObject = (JSONObject)this.iterator.next();
            String id = jsonObject.getString("id");
            JSONObject properties = (JSONObject)jsonObject.get("properties");
            SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(this.featureType);
            SimpleFeature feature = featureBuilder.buildFeature(id);
            feature.setAttribute("entityId", (Object)id);
            feature.setAttribute("provider", (Object)this.provider.providerName());
            try {
                Geometry geometry = new GeometryJSON().read((Object)jsonObject.get("geometry").toString());
                geometry.setSRID(4326);
                feature.setDefaultGeometry((Object)geometry);
            }
            catch (IOException e) {
                LOGGER.warn("Unable to read geometry '" + e.getMessage() + "'");
            }
            List descriptorList = this.featureType.getAttributeDescriptors();
            int icount = descriptorList.size();
            for (int i = 3; i < icount; ++i) {
                AttributeDescriptor descriptor = (AttributeDescriptor)descriptorList.get(i);
                String name = descriptor.getLocalName();
                Class binding = descriptor.getType().getBinding();
                Object value = properties.get(name);
                if (value == null) continue;
                try {
                    value = binding == Date.class ? DateUtilities.parseISO((String)value.toString()) : Converters.convert((Object)value, (Class)binding);
                }
                catch (ParseException e) {
                    LOGGER.warn("Unable to convert attribute '" + e.getMessage() + "'");
                    value = null;
                }
                feature.setAttribute(name, value);
            }
            return feature;
        }
    }
}

