/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.sentinel2;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.converters.ISO8601DateConverter;
import com.beust.jcommander.converters.IntegerConverter;
import java.util.Date;
import org.locationtech.geowave.adapter.vector.ingest.CQLFilterOptionProvider;
import org.opengis.filter.Filter;

public class Sentinel2BasicCommandLineOptions {
    private static final String DEFAULT_WORKSPACE_DIR = "sentinel2";
    @Parameter(names={"-ws", "--workspaceDir"}, description="A local directory to write temporary files needed for Sentinel2 ingest. Default is <TEMP_DIR>/sentinel2")
    private String workspaceDir = "sentinel2";
    @Parameter(names={"--provider"}, description="Name of Sentinel2 provider ('THEIA','AWS').")
    private String providerName = "THEIA";
    @Parameter(names={"--collection"}, description="Product collection to fetch within Sentinel2 collections ('SENTINEL2').")
    private String collection = "SENTINEL2";
    @Parameter(names={"--platform"}, description="Satellite ('SENTINEL2A','SENTINEL2B',...).")
    private String platform = "";
    @Parameter(names={"--location"}, description="Product location, 100 km Grid Square ID of the Military Grid Reference System (EX: 'T30TWM').")
    private String location = "";
    @Parameter(names={"-s", "--startdate"}, description="Optional start Date filter.", converter=ISO8601DateConverter.class)
    private Date startDate;
    @Parameter(names={"-f", "--enddate"}, description="Optional end Date filter.", converter=ISO8601DateConverter.class)
    private Date endDate;
    @Parameter(names={"--orbitnumber"}, description="Optional Orbit Number filter.", converter=IntegerConverter.class)
    private int orbitNumber = 0;
    @Parameter(names={"--relativeorbitnumber"}, description="Optional Relative Orbit Number filter.", converter=IntegerConverter.class)
    private int relativeOrbitNumber = 0;
    @Parameter(names={"--cql"}, description="An optional CQL expression to filter the ingested imagery. The feature type for the expression has the following attributes: shape (Geometry), location (String), productIdentifier (String), productType (String), collection (String), platform (String), processingLevel (String), startDate (Date), quicklook (String), thumbnail (String), bands (String), resolution (int), cloudCover (int), snowCover (int), waterCover (int), orbitNumber (int), relativeOrbitNumber (int) and the feature ID is entityId for the scene.  Additionally attributes of the individuals band can be used such as band (String).", converter=CQLFilterOptionProvider.ConvertCQLStrToFilterConverter.class)
    private CQLFilterOptionProvider.FilterParameter cqlFilter = new CQLFilterOptionProvider.FilterParameter(null, null);

    public String getWorkspaceDir() {
        return this.workspaceDir;
    }

    public Filter getCqlFilter() {
        if (this.cqlFilter != null) {
            return this.cqlFilter.getFilter();
        }
        return null;
    }

    public String providerName() {
        return this.providerName;
    }

    public String collection() {
        return this.collection;
    }

    public String platform() {
        return this.platform;
    }

    public String location() {
        return this.location;
    }

    public Date startDate() {
        return this.startDate;
    }

    public Date endDate() {
        return this.endDate;
    }

    public int orbitNumber() {
        return this.orbitNumber;
    }

    public int relativeOrbitNumber() {
        return this.relativeOrbitNumber;
    }

    public void setWorkspaceDir(String workspaceDir) {
        this.workspaceDir = workspaceDir;
    }

    public void setCqlFilter(String cqlFilter) {
        this.cqlFilter = new CQLFilterOptionProvider.ConvertCQLStrToFilterConverter().convert(cqlFilter);
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public void setOrbitNumber(int orbitNumber) {
        this.orbitNumber = orbitNumber;
    }

    public void setRelativeOrbitNumber(int relativeOrbitNumber) {
        this.relativeOrbitNumber = relativeOrbitNumber;
    }
}

