/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.sentinel2;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.visitor.ExtractBoundsFilterVisitor;
import org.geotools.referencing.CRS;
import org.locationtech.geowave.format.sentinel2.PropertyIgnoringFilterVisitor;
import org.locationtech.geowave.format.sentinel2.Sentinel2ImageryProvider;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SceneFeatureIterator
implements SimpleFeatureIterator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SceneFeatureIterator.class);
    private static final String SCENES_DIR = "scenes";
    public static final String SHAPE_ATTRIBUTE_NAME = "shape";
    public static final String ENTITY_ID_ATTRIBUTE_NAME = "entityId";
    public static final String PROVIDER_NAME_ATTRIBUTE_NAME = "provider";
    public static final String LOCATION_ATTRIBUTE_NAME = "location";
    public static final String PRODUCT_ID_ATTRIBUTE_NAME = "productIdentifier";
    public static final String PRODUCT_TYPE_ATTRIBUTE_NAME = "productType";
    public static final String COLLECTION_ATTRIBUTE_NAME = "collection";
    public static final String PLATFORM_ATTRIBUTE_NAME = "platform";
    public static final String PROCESSING_LEVEL_ATTRIBUTE_NAME = "processingLevel";
    public static final String ACQUISITION_DATE_ATTRIBUTE_NAME = "startDate";
    public static final String QUICKLOOK_ATTRIBUTE_NAME = "quicklook";
    public static final String THUMBNAIL_ATTRIBUTE_NAME = "thumbnail";
    public static final String BANDS_ATTRIBUTE_NAME = "bands";
    public static final String RESOLUTION_ATTRIBUTE_NAME = "resolution";
    public static final String CLOUD_COVER_ATTRIBUTE_NAME = "cloudCover";
    public static final String SNOW_COVER_ATTRIBUTE_NAME = "snowCover";
    public static final String WATER_COVER_ATTRIBUTE_NAME = "waterCover";
    public static final String ORBIT_NUMBER_ATTRIBUTE_NAME = "orbitNumber";
    public static final String RELATIVE_ORBIT_NUMBER_ATTRIBUTE_NAME = "relativeOrbitNumber";
    public static final String SCENE_DOWNLOAD_ATTRIBUTE_NAME = "sceneDownloadUrl";
    private Sentinel2ImageryProvider provider;
    private Iterator<SimpleFeature> iterator;
    private SimpleFeatureType type;

    public static SimpleFeatureTypeBuilder defaultSceneFeatureTypeBuilder(String typeName) throws NoSuchAuthorityCodeException, FactoryException {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName(typeName);
        typeBuilder.setCRS(CRS.decode((String)"EPSG:4326", (boolean)true));
        typeBuilder.setDefaultGeometry(SHAPE_ATTRIBUTE_NAME);
        typeBuilder.add(SHAPE_ATTRIBUTE_NAME, Polygon.class);
        typeBuilder.minOccurs(1).maxOccurs(1).nillable(false).add(ENTITY_ID_ATTRIBUTE_NAME, String.class);
        typeBuilder.minOccurs(1).maxOccurs(1).nillable(false).add(PROVIDER_NAME_ATTRIBUTE_NAME, String.class);
        typeBuilder.minOccurs(1).maxOccurs(1).nillable(false).add(LOCATION_ATTRIBUTE_NAME, String.class);
        typeBuilder.minOccurs(1).maxOccurs(1).nillable(false).add(PRODUCT_ID_ATTRIBUTE_NAME, String.class);
        typeBuilder.minOccurs(1).maxOccurs(1).nillable(false).add(PRODUCT_TYPE_ATTRIBUTE_NAME, String.class);
        typeBuilder.minOccurs(1).maxOccurs(1).nillable(false).add(COLLECTION_ATTRIBUTE_NAME, String.class);
        typeBuilder.minOccurs(1).maxOccurs(1).nillable(false).add(PLATFORM_ATTRIBUTE_NAME, String.class);
        typeBuilder.add(PROCESSING_LEVEL_ATTRIBUTE_NAME, String.class);
        typeBuilder.add(ACQUISITION_DATE_ATTRIBUTE_NAME, Date.class);
        typeBuilder.add(QUICKLOOK_ATTRIBUTE_NAME, String.class);
        typeBuilder.add(THUMBNAIL_ATTRIBUTE_NAME, String.class);
        typeBuilder.add(BANDS_ATTRIBUTE_NAME, String.class);
        typeBuilder.add(RESOLUTION_ATTRIBUTE_NAME, Integer.class);
        typeBuilder.add(CLOUD_COVER_ATTRIBUTE_NAME, Integer.class);
        typeBuilder.add(SNOW_COVER_ATTRIBUTE_NAME, Integer.class);
        typeBuilder.add(WATER_COVER_ATTRIBUTE_NAME, Integer.class);
        typeBuilder.add(ORBIT_NUMBER_ATTRIBUTE_NAME, Integer.class);
        typeBuilder.add(RELATIVE_ORBIT_NUMBER_ATTRIBUTE_NAME, Integer.class);
        typeBuilder.add(SCENE_DOWNLOAD_ATTRIBUTE_NAME, String.class);
        return typeBuilder;
    }

    public SceneFeatureIterator(String providerName, String collection, String platform, String location, Date startDate, Date endDate, int orbitNumber, int relativeOrbitNumber, Filter cqlFilter, String workspaceDir) throws NoSuchAuthorityCodeException, FactoryException, MalformedURLException, IOException, GeneralSecurityException {
        this.init(new File(workspaceDir, SCENES_DIR), providerName, collection, platform, location, startDate, endDate, orbitNumber, relativeOrbitNumber, cqlFilter);
    }

    private void init(File scenesDir, String providerName, String collection, String platform, String location, Date startDate, Date endDate, int orbitNumber, int relativeOrbitNumber, Filter cqlFilter) throws NoSuchAuthorityCodeException, FactoryException, IOException, GeneralSecurityException {
        if (!scenesDir.exists() && !scenesDir.mkdirs()) {
            LOGGER.warn("Unable to create directory '" + scenesDir.getAbsolutePath() + "'");
        }
        this.provider = Sentinel2ImageryProvider.getProvider(providerName);
        if (this.provider == null) {
            throw new RuntimeException("Unable to find '" + providerName + "' Sentinel2 provider");
        }
        Envelope envelope = null;
        if (cqlFilter != null && !cqlFilter.equals(Filter.INCLUDE)) {
            Envelope bounds = new Envelope();
            if ((bounds = (Envelope)cqlFilter.accept((FilterVisitor)ExtractBoundsFilterVisitor.BOUNDS_VISITOR, (Object)bounds)) != null && !bounds.isNull() && !bounds.equals((Object)this.infinity())) {
                envelope = bounds;
            }
        }
        SimpleFeatureTypeBuilder typeBuilder = this.provider.sceneFeatureTypeBuilder();
        this.type = typeBuilder.buildFeatureType();
        UnmodifiableIterator featureIterator = this.provider.searchScenes(scenesDir, collection, platform, location, envelope, startDate, endDate, orbitNumber, relativeOrbitNumber);
        if (featureIterator != null && cqlFilter != null && !cqlFilter.equals(Filter.INCLUDE)) {
            Filter actualFilter;
            if (this.hasOtherProperties(cqlFilter)) {
                List descriptorList = this.type.getAttributeDescriptors();
                String[] propertyNames = new String[descriptorList.size()];
                int icount = descriptorList.size();
                for (int i = 0; i < icount; ++i) {
                    propertyNames[i] = ((AttributeDescriptor)descriptorList.get(i)).getLocalName();
                }
                PropertyIgnoringFilterVisitor visitor = new PropertyIgnoringFilterVisitor(propertyNames, this.type);
                actualFilter = (Filter)cqlFilter.accept((FilterVisitor)visitor, null);
            } else {
                actualFilter = cqlFilter;
            }
            CqlFilterPredicate filterPredicate = new CqlFilterPredicate(actualFilter);
            featureIterator = Iterators.filter(featureIterator, (Predicate)filterPredicate);
        }
        this.iterator = featureIterator;
    }

    private boolean hasOtherProperties(Filter cqlFilter) {
        String[] attributes;
        for (String attribute : attributes = DataUtilities.attributeNames((Filter)cqlFilter, (SimpleFeatureType)this.type)) {
            if (this.type.getDescriptor(attribute) != null) continue;
            return true;
        }
        return false;
    }

    public SimpleFeatureType getFeatureType() {
        return this.type;
    }

    public Sentinel2ImageryProvider getProvider() {
        return this.provider;
    }

    public void close() {
    }

    public boolean hasNext() {
        if (this.iterator != null) {
            return this.iterator.hasNext();
        }
        return false;
    }

    public SimpleFeature next() throws NoSuchElementException {
        if (this.iterator != null) {
            return this.iterator.next();
        }
        return null;
    }

    private Envelope infinity() {
        return new Envelope(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public static class CqlFilterPredicate
    implements Predicate<SimpleFeature> {
        private final Filter cqlFilter;

        public CqlFilterPredicate(Filter cqlFilter) {
            this.cqlFilter = cqlFilter;
        }

        public boolean apply(SimpleFeature input) {
            return this.cqlFilter.evaluate((Object)input);
        }
    }
}

